package gov.va.med.esr.service.external.person;

import gov.va.med.esr.service.external.EntityFinder;
import gov.va.med.esr.service.external.person.collections.CategoryCollection;

public class PersonFinderFactory {
	public static EntityFinder createSSNFinder(String data, String accountName, String requestName) {
		EntityFinder finder = new SSNEntityFinder(data,  accountName,  requestName);
		return finder;
	}
	
	public static EntityFinder createSSNFinder(String data, Integer incomeYear, String accountName, String requestName) {
		SSNEntityFinder finder = new SSNEntityFinder(data,  accountName,  requestName);
		finder.setIncomeYear(incomeYear);
		return finder;
	}
	
	public static EntityFinder createLNSFinder(String data, String accountName, String requestName) {
		EntityFinder finder = new LNSEntityFinder(data);
		return finder;
	}
	
	public static EntityFinder createLNSFinder(String data, Integer incomeYear, String accountName, String requestName) {
		LNSEntityFinder finder = new LNSEntityFinder(data);
		finder.setIncomeYear(incomeYear);
		return finder;
	}
	
	public static EntityFinder createVPIDFinder(String data, String accountName, String requestName) {
		EntityFinder finder = new VPIDEntityFinder(data,  accountName,  requestName);
		return finder;
	}	
	
	public static EntityFinder createVPIDFinder(String data, Integer incomeYear, String accountName, String requestName) {
		VPIDEntityFinder finder = new VPIDEntityFinder(data,  accountName,  requestName);
		finder.setIncomeYear(incomeYear);
		return finder;
	}
    
    public static EntityFinder createSSNFinder(String data, String accountName, String requestName,CategoryCollection categories) {
        EntityFinder finder = new SSNEntityFinder(data,  accountName,  requestName,categories);
        return finder;
    }
    
    public static EntityFinder createLNSFinder(String data, String accountName, String requestName,CategoryCollection categories) {
        EntityFinder finder = new LNSEntityFinder(data);
        return finder;
    }
    
    
    public static EntityFinder createVPIDFinder(String data, String accountName, String requestName,CategoryCollection categories) {
        EntityFinder finder = new VPIDEntityFinder(data,  accountName,  requestName,categories);
        return finder;
    }
    
    public static EntityFinder createVPIDFinder(String data, String accountName, String requestName,
    		String notificationType,String survivingVpid,String deprecatedVpid,String dfn,String stationNumber,
    		String fromVpid, String toVpid) {
        EntityFinder finder = new VPIDEntityFinder(data,  accountName, notificationType,survivingVpid,deprecatedVpid,
        		dfn,stationNumber,fromVpid,toVpid);
        return finder;
    }
    
    public static EntityFinder createVPIDFinder(String data, String accountName, String requestName,DeliveryPreferenceInfo deliveryPreferenceInfo) {
        EntityFinder finder = new VPIDEntityFinder(data,  accountName,  requestName,deliveryPreferenceInfo);
        return finder;
    }
    
    public static EntityFinder createEDIPIFinder(String data, String accountName, String requestName) {
		EntityFinder finder = new EDIPIEntityFinder(data,  accountName,  requestName);
		return finder;
	}
    public static EntityFinder createEDIPIFinder(String data,Integer incomeYear, String accountName, String requestName) {
		EDIPIEntityFinder finder = new EDIPIEntityFinder(data, accountName,  requestName);
		finder.setIncomeYear(incomeYear);
		return finder;
	}
    
    public static EntityFinder createVPIDFinder(String data, Integer incomeYear,String accountName, String requestName,
    		SendIVMInfo sendIVMInfo, IVMLetterInfo ivmLetterInfo) {
        EntityFinder finder = new VPIDEntityFinder(data,  accountName,  requestName, incomeYear,sendIVMInfo, ivmLetterInfo);
        return finder;
    }    
    


	

	
}
