package gov.va.med.esr.service.external.person;

import gov.va.med.esr.service.external.ExternalComponent;

import java.util.Date;

public class NoseThroatRadiumInfo extends ExternalComponent {


	private static final long serialVersionUID = -99771785809446530L;

	/*
	 * OBX(for NTR)/14/Z11
	 */
	private Date verificationDate = null;

    /**
     * The (NTR) Verification Method is defined as a list of values that is used
     * to state the documentation used to verify the NTR claim. Values include:
     * M: Military Record S: Qualifying Military Service N: Not qualified.
     * OBX(for NTR)/17/Z11
     */
    private String verificationMethod = null;

    /**
     * (NTR) Verification Method Station Number is defined as the Site that did
     * the Reporting of the Verification Method Status. Values are set on the
     * VistA system using the Institution file.
     * OBX(for NTR)/15/Z11
     */
    private String verificationFacility = null;

    /**
     * OBX(for NTR)/16/Z11
     */
    private String determinationFacility = null;
   
    /**
     * Received NTR Treatment defines the answer a veteran gave to the question:
     * DID YOU RECEIVE NOSE OR THROAT RADIUM TREATMENTS IN THE MILITARY? Values
     * include YES NO Unknown.
     * OBX(for NTR)/5/Z11
     */
    private String receivingTreatment = null;
    
    /**
     * Aviation Prior to 1955 is a defined as the question that is presented to
     * the user if the veteran has answered YES to the NTR Indicator. The
     * question is Did you serve as an aviator in the Military before Jan 31,
     * 1955? The values include YES/NO.
     * 
     * OBX(for NTR)/5/Z11
     * 
     * @hibernate.property insert="true" update="true"
     *                     column="NTR_AVIATOR_PRE1955_IND"
     *                      
     */
    private Boolean fromAviatorServiceBefore1955 = null;

    /**
     * Submarine Trainee prior to 1965 is defined as the question that is
     * presented to the user if the veteran has answered YES to the NTR
     * Indicator. The question is Did you have submarine training in the
     * military before Jan 1, 1965? Values include YES/NO.
     * 
     * OBX(for NTR)/5/Z11
     */
    private Boolean fromSubmarinerServiceBefore1965 = null;

    /**
     *Diagnosed with Cancer of Head Neck is defined as the question that is presented to 
     *the user if the veteran has answered YES to the NTR Indicator.  
     *Values include YES/NO. Display Only on EDB. 
 	 * OBX(for NTR)/5/Z11
     */
     private Boolean diagnosedWithCancer = null;
     
     /* If for NTR the value is: Diagnosed With Head and Neck Cancer Date/Time (Precise)N/A for patient sensitivity
      * OBX(for NTR)/12/Z11
      */     
     private Date diagnosisVerifiedDate = null;

	public String getDeterminationFacility() {
		return determinationFacility;
	}

	public void setDeterminationFacility(String determinationFacility) {
		this.determinationFacility = determinationFacility;
	}

	public Boolean getDiagnosedWithCancer() {
		return diagnosedWithCancer;
	}

	public void setDiagnosedWithCancer(Boolean diagnosedWithCancer) {
		this.diagnosedWithCancer = diagnosedWithCancer;
	}

	public Date getDiagnosisVerifiedDate() {
		return diagnosisVerifiedDate;
	}

	public void setDiagnosisVerifiedDate(Date diagnosisVerifiedDate) {
		this.diagnosisVerifiedDate = diagnosisVerifiedDate;
	}

	public Boolean getFromAviatorServiceBefore1955() {
		return fromAviatorServiceBefore1955;
	}

	public void setFromAviatorServiceBefore1955(Boolean fromAviatorServiceBefore1955) {
		this.fromAviatorServiceBefore1955 = fromAviatorServiceBefore1955;
	}

	public Boolean getFromSubmarinerServiceBefore1965() {
		return fromSubmarinerServiceBefore1965;
	}

	public void setFromSubmarinerServiceBefore1965(
			Boolean fromSubmarinerServiceBefore1965) {
		this.fromSubmarinerServiceBefore1965 = fromSubmarinerServiceBefore1965;
	}

	public String getReceivingTreatment() {
		return receivingTreatment;
	}

	public void setReceivingTreatment(String receivingTreatment) {
		this.receivingTreatment = receivingTreatment;
	}

	public Date getVerificationDate() {
		return verificationDate;
	}

	public void setVerificationDate(Date verificationDate) {
		this.verificationDate = verificationDate;
	}

	public String getVerificationFacility() {
		return verificationFacility;
	}

	public void setVerificationFacility(String verificationFacility) {
		this.verificationFacility = verificationFacility;
	}

	public String getVerificationMethod() {
		return verificationMethod;
	}

	public void setVerificationMethod(String verificationMethod) {
		this.verificationMethod = verificationMethod;
	}
     
     
}
