package gov.va.med.esr.service.external.person;

import java.util.Date;

import gov.va.med.esr.service.external.ExternalComponent;


public class MonetaryBenefitInfo extends ExternalComponent {



	private static final long serialVersionUID = -9108651424639547758L;

	/**
	 * Can be one of: AidAndAttendance, ReceivingDiabilityCompensation,
	 * Housebound, VAPension.
	 * 
	 * @hibernate.many-to-one class="gov.va.med.esr.common.model.lookup.MonetaryBenefitType"
	 *                        cascade="none" not-null="true" insert="true"
	 *                        update="true"
	 * @hibernate.column name="VBA_FACTOR_TYPE_ID"
	 * ZEL/14/Z11
	 * ZEL/15/Z11
	 * ZEL/16/Z11
	 * ZEL/17/Z11
	 */
	private String type = null;

	/**
	 * MonetaryBenefit Indicator. This is a set of codes: 1- FOR PERMANENT; 2- FOR NOT PERMANENT; 3-
	 * FOR UNKNOWN
	 */
	private Boolean monetaryBenefitIndicator = null;
	private Date monetaryBenefitReportDate;
	
	public MonetaryBenefitInfo(){
		super();
	}

	public Boolean getMonetaryBenefitIndicator() {
		return monetaryBenefitIndicator;
	}

	public void setMonetaryBenefitIndicator(Boolean monetaryBenefitIndicator) {
		this.monetaryBenefitIndicator = monetaryBenefitIndicator;
	}
	

	public Date getMonetaryBenefitReportDate() {
		return monetaryBenefitReportDate;
	}

	public void setMonetaryBenefitReportDate(Date monetaryBenefitReportDate) {
		this.monetaryBenefitReportDate = monetaryBenefitReportDate;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}
}
