package gov.va.med.esr.service.external.person;

import gov.va.med.esr.service.external.ExternalComponent;

import java.util.Date;

public class IneligibilityFactorInfo extends ExternalComponent {

	private static final long serialVersionUID = 2409599165477345760L;

	/**
	 * Ineligible date is defined as the effective date this veteran was found
	 * to be ineligible for VHA healthcare.
	 * 
	 * @hibernate.property insert="true" update="true" column="START_DATE"
	 * ZIE/2/Z11
	 */
    private Date ineligibleDate = null;

    /**
	 * Ineligible Reason is defined as the free text entry made by the user if
	 * the veteran is ineligible for treatment . It is not to exceed 40
	 * characters.. An ineligible date must be specified in order to enter/edit
	 * this field and This field may not be deleted as long as an ineligible
	 * date is on file
	 * 
	 * @hibernate.property insert="true" update="true" column="COMMENT_TEXT"
	 *                     length="2000"
	 *  ZIE/3/Z11
	 */
    private String reason = null;

    /**
	 * The Ineligible VARO Decision is defined as the VARO decision concerning
	 * this applicant's ineligibility. This field is between 3-75 characters. An
	 * ineligible date must be specified in order to enter/edit this field.
	 * 
	 * @hibernate.property insert="true" update="true"
	 *                     column="REGIONAL_OFFICE_DECISION_TEXT" length="150"
	 * ZIE/4/Z11
	 */
    private String varoDecision = null;
    
    /**
     * Site that sent the ineligibility data
     */
    private String facilityReceived = null;
    //16 fields
    private Date recordCreatedDate = null;

	public String getFacilityReceived() {
		return facilityReceived;
	}

	public void setFacilityReceived(String facilityReceived) {
		this.facilityReceived = facilityReceived;
	}

	public Date getIneligibleDate() {
		return ineligibleDate;
	}

	public void setIneligibleDate(Date ineligibleDate) {
		this.ineligibleDate = ineligibleDate;
	}

	public String getReason() {
		return reason;
	}

	public void setReason(String reason) {
		this.reason = reason;
	}

	public String getVaroDecision() {
		return varoDecision;
	}

	public void setVaroDecision(String varoDecision) {
		this.varoDecision = varoDecision;
	}

    public Date getRecordCreatedDate() {
        return recordCreatedDate;
    }

    public void setRecordCreatedDate(Date recordCreatedDate) {
        this.recordCreatedDate = recordCreatedDate;
    }

}
