package gov.va.med.esr.service.external.person;

import gov.va.med.esr.service.external.ExternalComponent;

import java.util.Date;

public class IncomeTestStatusInfo extends ExternalComponent {

	private static final long serialVersionUID = -211790501475084128L;

	/*
	 * ZMT (1)(MT)/26/Z10
	 */
	private String   determinedStatus = null;
	
    /**
     * Date/time completed is defined as the date/time that the test was
     * completed. This field is used to indicate when a veteran agreed to pay
     * co-payment, and is used for billing purposes. Date must be precise.
     * Cannot be a Future Date
     * ZMT (1)(MT)/10/Z10
     */
    private Date              completedDate    = null;

    /**
     * Date/Time last edited is defined as the date/time the test was last
     * edited
     * ZMT (1)(MT)/25/Z10
     */
    private Date              lastEditedDate   = null;

    /**
     * Type of Test is defined as the type of test associated with the financial
     * test. Choices: Means Test, Pharmacy Co-pay Test , Long Term Care Copay,
     * Exemption Test - type 4 test, LTC copay test - Type 3 test.
     * ZMT (1)(MT)/17/Z10
     */
    private String    incomeTestType             = null;

    /**
     * Can be one of the following:
     * 
     * Means Test Status is defined as the status for the type of test MT. The
     * choices are:MT Copay Exempt, MT Copay Required, No Longer Required,
     * Required, Pending Adjudication, GMT Copay required.
     * 
     * Pharmacy copay status is defined as the status for the type of test
     * Pharmacy copay Test. The acceptable choices are: Exempt, Non-Exempt,
     * Incomplete, No Longer Applicable.
     * 
     * Long Term Care status is defined as the status of the type of test LTC
     * suppliedThe acceptable choices are:ExemptNon Exempt
     * ZMT (1)(MT)/3/Z10
     */
    private String   status           = null;

	public Date getCompletedDate() {
		return completedDate;
	}

	public void setCompletedDate(Date completedDate) {
		this.completedDate = completedDate;
	}

	public String getDeterminedStatus() {
		return determinedStatus;
	}

	public void setDeterminedStatus(String determinedStatus) {
		this.determinedStatus = determinedStatus;
	}

	public String getIncomeTestType() {
		return incomeTestType;
	}

	public void setIncomeTestType(String incomeTestType) {
		this.incomeTestType = incomeTestType;
	}

	public Date getLastEditedDate() {
		return lastEditedDate;
	}

	public void setLastEditedDate(Date lastEditedDate) {
		this.lastEditedDate = lastEditedDate;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

}
