package gov.va.med.esr.service.external.person;

import gov.va.med.esr.service.external.ExternalComponent;
import gov.va.med.esr.service.external.person.collections.IncomeTestStatusCollection;

import java.math.BigDecimal;
import java.util.Date;

public class IncomeTestInfo extends ExternalComponent {

	
	private static final long serialVersionUID = 546261404077610171L;


	private HardshipInfo hardshipInfo;

    /**
     * Hardship reason is defined as a reason this person has been granted a
     * hardship.
     */
    private String            hardShipReason               = null;
    private AddressInfo gmtAddressInfo;
    private Integer           incomeYear                   = null;

    /**
     * Disclose Financial Information Indicator is defined as an indicator where
     * the Veteran chooses Yes/No to disclose Financial Information. Disclose
     * Financial InformationIndicator is a required field that is user supplied
     * and occurs only once.
     * ZMT (1)(MT)/16/Z10
     */
    private Boolean           discloseFinancialInformation = null;

    /**
     * Agree to Pay Deductible Indicator is defined as an indicator where the
     * Veteran chooses Yes or No to pay deductible. Veteran must answer yes or
     * no if veteran has a MT status of non exempt. This indicator is set to YES
     * when an IVM case is closed converted by the IVM process. IF veteran
     * chooses 'No' he is considered Ineligible.
     * ZMT (1)(MT)/7/Z10
     */
    private Boolean           agreesToPayDeductible        = null;

    /**
     * Effective Date of Test is defined as the effective date of the primary
     * test for the income year. Date must be precise. This date + 364 days is
     * the date that a new MT is required.
     * ZMT (1)(MT)/2/Z10
     */
    private Date              effectiveDate                = null;

    /**
     * Total Dependents is defined as a summation of the dependents and spouse
     * (if applicable). If the veteran has children, the children will only be
     * collected as dependents if the children lived with veteran last calendar
     * year or if the child did not live with veteran the veteran must have
     * contributed > $25 in child supportIf the veteran is married, the spouse's
     * will only be collected and subsequently included under certain
     * conditions. The veteran and spouse must either live together or if they
     * do not live together, the veteran must have contributed at least $600 to
     * the spouse's support during the previous calendar year.
     * ZMT (1)(MT)/12/Z10
     */
    private Integer           totalNumberOfDependents      = null;

    /**
     * Previous Years Threshold is defined as a code to indicate if the previous
     * years means test parameters are applied to the test. This should only
     * occur when the new parameters are not yet available to the field.
     * Acceptable choices are Yes/No.
     * ZMT (1)(MT)/11/Z10
     */
    private Boolean           previousYearThresholdApplies = null;

    /**
     * Primary MT indicator is defined as the indicator that is set by the
     * system when a MT is determined to be primary.
     * ZMT (1)(MT)/19/Z10
     */
    private Boolean           primaryIncomeTest            = null;

    /**
     * Future test indicator is defined as the indicator that is set by the
     * system when a test is determined to be future income test.
     */
    private Boolean           futureTest            = null;

    /**
     * Source Of Test is defined as the source from which this income test was
     * received. It indicates where the income test originated 1. This is the
     * authoritative source for changes to this particular test. 2. If HEC makes
     * changes to the original MT supplied by the VAMC, other than the effective
     * date of test, making a future test the source of test is changed to DCD
     * (HEC), which will prevent the site that created the test from editing it.
     * 3. If HEC only changes the effective date of test, making it a future
     * test the source remains the original source
     * 
     * Choices are: IVM, HEC, OTHER FACILITY, VAMC.
     */
    private String  incomeTestsource                       = null;

    private String incomeTestType;
    private Date incomeTestReportDate;
    /**
     * Threshold A is defined as the income threshold A as determined by the
     * system for the veteran. The threshold is determined by the system in the
     * following manner:Cat A Vet Income + Cat A First Dependent+(Cat A Per
     * Dependent*(Num Dependent-First Dependent)). The means test thresholds are
     * released annually by VHA and include the veteran and dependent income for
     * the year.
     * ZMT (1)(MT)/9/Z10
     */
    private BigDecimal        thresholdA                   = null;

    /**
     * GMT Threshold dollar amount is defined as the income GMT threshold as
     * determined by the system for the veteran. This threshold is derived by a
     * look up to the HUD indices table. The threshold amount is computed as
     * FIPS code + MSA code for # of dependents.
     * ZMT (1)(MT)/28/Z10
     */
    private BigDecimal        gmtThresholdAmount           = null;


    /**
     * Site conducting MT is defined as the station ID of the site that supplied
     * the MT.
     * ZMT (1)(MT)/22/Z10
     */
    private String        siteConductingTest           = null;

    /**
     * Date/Time of Adjudication is defined as the last date/time the financial
     * test was adjudicated. Date must be precise
     * ZMT (1)(MT)/6/Z10
     */
    private Date              adjudicationDate             = null;

    /**
     * Date IVM MT Completed is defined as the Primary EDB MT completed date
     * associated with the IVM closed case.
     */
    private Date              ivmTestCompletionDate        = null;

    /**
     * Income verification status is defined as the outcome status of the income
     * verification process. The choices are: Converted - MT Copay Required,
     * Converted - GMT Copay Required, NOT Converted - MT copay Exempt.
     */
    private String   incomeVerificationStatus     = null;

    /**
     * Income verification status date is defined as the date the income
     * verification status is set
     */
    private Date              incomeVerificationStatusDate = null;

    /**
     * Refused to sign is defined as an indicator Yes/No where through the
     * Income verification process the veteran refuses to sign 1010EZ verifying
     * his income information
     */
    private Boolean           refusedToSign                = null;

    /**
     * Reason MT status is no longer required is defined as the reason a MT
     * status changes to no longer required. The allowable choices are:PH, VA
     * Pension, Compensable SC, POW, Medicaid Eligible, Discharged for
     * disability.
     */
    private BigDecimal        reasonMTNoLongerRequired     = null;

    /**
     * Date MT no longer required is defined as the date a MT is determined no
     * longer requiredFormat is a date field Date must be precise
     */
    private Date              dateMTNoLongerRequired       = null;

    /**
     * Total income is the summation of applicable income of the
     * veteran, spouse and all the valid dependents.
     * ZMT (1)(MT)/4/Z10
     */
    private BigDecimal        totalIncome                  = null;
    
    /**
     * Net income is sum of all the applicable income of veteran, spouse
     * and valid dependents minus applicable expenses.
     */
    private BigDecimal        netIncome                    = null;

    /**
     * Deductible Expenses is defined as the summation of the veteran's
     * deductible expenses (medical, burial and educational)
     * ZMT (1)(MT)/9/Z10
     */
    private BigDecimal        deductibleExpenses           = null;

    /**
     * Net Worth is defined as a summation of the veteran and spouse (if
     * applicable) net worth minus any debts for the previous calendar year from
     * date of testIf the veteran is married, the spouse's income will only be
     * collected and subsequently included in the test under certain conditions.
     * The veteran and spouse must either live together or if they do not live
     * together, the veteran must have contributed at least $600 to the spouse's
     * support during the previous Calendar year
     * 
     * When determining the means test status and subsequent category of care,
     * the system will require net worth be entered for those veteran's who
     * require mandatory care
     * 
     * If the income plus net worth exceed the annual property threshold, the
     * case can be sent to adjudication for the test
     * 
     * Calculation is as follows:Net worth =(Bank account amount + Stock and
     * Bond amounts + Real Property Value + Other property and assets) - Debts
     * ZMT (1)(MT)/5/Z10
     */
    private BigDecimal        netWorth                     = null;
    private String            comments                     = null;
    private IncomeTestStatusCollection               statuses             = null;
    private BigDecimal        networthThreshold            = null;
    private BigDecimal        pensionThreshold             = null;    
    private BigDecimal        childIncomeExclusionThreshold     = null;
    
    /**
     * CAD is Centralized Anniversary Date
     */
    private Boolean           cadAdjusted                  = null;
    
    /**
     * Internal variable to hold the user response whether to send the case for
     * adjudication in certain cases.
     * Value of this variable is used to determine the value of means test status 
     * code in those certain cases.
     */
    private Boolean		      sendForAdjudication          = null;
    private Boolean priorityGroup8Relaxation = null;
    private Date ivmConversionDate = null;
    private String ivmCaseStatus = null;
    
	public Date getAdjudicationDate() {
		return adjudicationDate;
	}

	public void setAdjudicationDate(Date adjudicationDate) {
		this.adjudicationDate = adjudicationDate;
	}

	public Boolean getAgreesToPayDeductible() {
		return agreesToPayDeductible;
	}

	public void setAgreesToPayDeductible(Boolean agreesToPayDeductible) {
		this.agreesToPayDeductible = agreesToPayDeductible;
	}

	public Boolean getCadAdjusted() {
		return cadAdjusted;
	}

	public void setCadAdjusted(Boolean cadAdjusted) {
		this.cadAdjusted = cadAdjusted;
	}

	public BigDecimal getChildIncomeExclusionThreshold() {
		return childIncomeExclusionThreshold;
	}

	public void setChildIncomeExclusionThreshold(
			BigDecimal childIncomeExclusionThreshold) {
		this.childIncomeExclusionThreshold = childIncomeExclusionThreshold;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public Date getDateMTNoLongerRequired() {
		return dateMTNoLongerRequired;
	}

	public void setDateMTNoLongerRequired(Date dateMTNoLongerRequired) {
		this.dateMTNoLongerRequired = dateMTNoLongerRequired;
	}

	public BigDecimal getDeductibleExpenses() {
		return deductibleExpenses;
	}

	public void setDeductibleExpenses(BigDecimal deductibleExpenses) {
		this.deductibleExpenses = deductibleExpenses;
	}

	public Boolean getDiscloseFinancialInformation() {
		return discloseFinancialInformation;
	}

	public void setDiscloseFinancialInformation(Boolean discloseFinancialInformation) {
		this.discloseFinancialInformation = discloseFinancialInformation;
	}

	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public Boolean getFutureTest() {
		return futureTest;
	}

	public void setFutureTest(Boolean futureTest) {
		this.futureTest = futureTest;
	}

	public BigDecimal getGmtThresholdAmount() {
		return gmtThresholdAmount;
	}

	public void setGmtThresholdAmount(BigDecimal gmtThresholdAmount) {
		this.gmtThresholdAmount = gmtThresholdAmount;
	}


	public String getHardShipReason() {
		return hardShipReason;
	}

	public void setHardShipReason(String hardShipReason) {
		this.hardShipReason = hardShipReason;
	}


	public String getIncomeTestsource() {
		return incomeTestsource;
	}

	public void setIncomeTestsource(String incomeTestsource) {
		this.incomeTestsource = incomeTestsource;
	}

	public String getIncomeTestType() {
		return incomeTestType;
	}

	public void setIncomeTestType(String incomeTestType) {
		this.incomeTestType = incomeTestType;
	}

	public String getIncomeVerificationStatus() {
		return incomeVerificationStatus;
	}

	public void setIncomeVerificationStatus(String incomeVerificationStatus) {
		this.incomeVerificationStatus = incomeVerificationStatus;
	}

	public Date getIncomeVerificationStatusDate() {
		return incomeVerificationStatusDate;
	}

	public void setIncomeVerificationStatusDate(Date incomeVerificationStatusDate) {
		this.incomeVerificationStatusDate = incomeVerificationStatusDate;
	}

	public Integer getIncomeYear() {
		return incomeYear;
	}

	public void setIncomeYear(Integer incomeYear) {
		this.incomeYear = incomeYear;
	}

	public Date getIvmTestCompletionDate() {
		return ivmTestCompletionDate;
	}

	public void setIvmTestCompletionDate(Date ivmTestCompletionDate) {
		this.ivmTestCompletionDate = ivmTestCompletionDate;
	}

	public BigDecimal getNetIncome() {
		return netIncome;
	}

	public void setNetIncome(BigDecimal netIncome) {
		this.netIncome = netIncome;
	}

	public BigDecimal getNetWorth() {
		return netWorth;
	}

	public void setNetWorth(BigDecimal netWorth) {
		this.netWorth = netWorth;
	}

	public BigDecimal getNetworthThreshold() {
		return networthThreshold;
	}

	public void setNetworthThreshold(BigDecimal networthThreshold) {
		this.networthThreshold = networthThreshold;
	}

	public BigDecimal getPensionThreshold() {
		return pensionThreshold;
	}

	public void setPensionThreshold(BigDecimal pensionThreshold) {
		this.pensionThreshold = pensionThreshold;
	}

	public Boolean getPreviousYearThresholdApplies() {
		return previousYearThresholdApplies;
	}

	public void setPreviousYearThresholdApplies(Boolean previousYearThresholdApplies) {
		this.previousYearThresholdApplies = previousYearThresholdApplies;
	}

	public Boolean getPrimaryIncomeTest() {
		return primaryIncomeTest;
	}

	public void setPrimaryIncomeTest(Boolean primaryIncomeTest) {
		this.primaryIncomeTest = primaryIncomeTest;
	}

	public BigDecimal getReasonMTNoLongerRequired() {
		return reasonMTNoLongerRequired;
	}

	public void setReasonMTNoLongerRequired(BigDecimal reasonMTNoLongerRequired) {
		this.reasonMTNoLongerRequired = reasonMTNoLongerRequired;
	}

	public Boolean getRefusedToSign() {
		return refusedToSign;
	}

	public void setRefusedToSign(Boolean refusedToSign) {
		this.refusedToSign = refusedToSign;
	}

	public Boolean getSendForAdjudication() {
		return sendForAdjudication;
	}

	public void setSendForAdjudication(Boolean sendForAdjudication) {
		this.sendForAdjudication = sendForAdjudication;
	}

	public String getSiteConductingTest() {
		return siteConductingTest;
	}

	public void setSiteConductingTest(String siteConductingTest) {
		this.siteConductingTest = siteConductingTest;
	}



	public IncomeTestStatusCollection getStatuses() {
		return statuses;
	}

	public void setStatuses(IncomeTestStatusCollection statuses) {
		this.statuses = statuses;
	}

	public BigDecimal getThresholdA() {
		return thresholdA;
	}

	public void setThresholdA(BigDecimal thresholdA) {
		this.thresholdA = thresholdA;
	}

	public BigDecimal getTotalIncome() {
		return totalIncome;
	}

	public void setTotalIncome(BigDecimal totalIncome) {
		this.totalIncome = totalIncome;
	}

	public Integer getTotalNumberOfDependents() {
		return totalNumberOfDependents;
	}

	public void setTotalNumberOfDependents(Integer totalNumberOfDependents) {
		this.totalNumberOfDependents = totalNumberOfDependents;
	}

	public HardshipInfo getHardshipInfo() {
		return hardshipInfo;
	}

	public void setHardshipInfo(HardshipInfo hardshipInfo) {
		this.hardshipInfo = hardshipInfo;
	}

	public AddressInfo getGmtAddressInfo() {
		return gmtAddressInfo;
	}

	public void setGmtAddressInfo(AddressInfo gmtAddressInfo) {
		this.gmtAddressInfo = gmtAddressInfo;
	}

	public Date getIncomeTestReportDate() {
		return incomeTestReportDate;
	}

	public void setIncomeTestReportDate(Date incomeTestReportDate) {
		this.incomeTestReportDate = incomeTestReportDate;
	}

	public Boolean getPriorityGroup8Relaxation() {
		return priorityGroup8Relaxation;
	}

	public void setPriorityGroup8Relaxation(Boolean priorityGroup8Relaxation) {
		this.priorityGroup8Relaxation = priorityGroup8Relaxation;
	}

	public Date getIvmConversionDate() {
		return ivmConversionDate;
	}

	public void setIvmConversionDate(Date ivmConversionDate) {
		this.ivmConversionDate = ivmConversionDate;
	}

	public String getIvmCaseStatus() {
		return ivmCaseStatus;
	}

	public void setIvmCaseStatus(String ivmCaseStatus) {
		this.ivmCaseStatus = ivmCaseStatus;
	}
}
