package gov.va.med.esr.service.external.person;

import gov.va.med.esr.service.external.ExternalComponent;
import gov.va.med.esr.service.external.person.collections.IVMCandidateCollection;
import gov.va.med.esr.service.external.person.collections.IVMLetterCandidateCollection;

public class IVMSummary extends ExternalComponent {
	
	private static final long serialVersionUID = -1947418609079216218L;
	
	private IVMCandidateCollection ivmCandidates;
	private IVMLetterCandidateCollection ivmLetterCandidates;	
	private String acknowledgement;
	private String status;
	
	public IVMCandidateCollection getIVMCandidates() {
		return ivmCandidates;
	}

	public void setIVMCandidates(IVMCandidateCollection ivmCandidates) {
		this.ivmCandidates = ivmCandidates;
	}

	public Integer getNumberOfIVMCandidates() {
		return (ivmHasCandidates())? ivmCandidates.getIVMCandidate().length: 0;
	}

	private boolean ivmHasCandidates() {
		return (ivmCandidates != null && 
				ivmCandidates.getIVMCandidate() != null && 
				ivmCandidates.getIVMCandidate().length > 0);
	}

	public String getAcknowledgement() {
		return acknowledgement;
	}

	public void setAcknowledgement(String acknowledgement) {
		this.acknowledgement = acknowledgement;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public IVMLetterCandidateCollection getIvmLetterCandidates() {
		return ivmLetterCandidates;
	}

	public void setIvmLetterCandidates(
			IVMLetterCandidateCollection ivmLetterCandidates) {
		this.ivmLetterCandidates = ivmLetterCandidates;
	}
}
