package gov.va.med.esr.service.external.person;

import gov.va.med.esr.service.external.EntityFinder;
import gov.va.med.esr.service.external.ExternalComponent;

import java.util.Date;

import com.bea.logging.DateFormatter;

public class IVMLastPolledEntityFinder extends ExternalComponent implements EntityFinder {
	private static final long serialVersionUID = -697502530395014361L;
	private Date lastPolledDateTimeStamp;
	
	public IVMLastPolledEntityFinder(Date lastPolledDateTimeStamp) {
		this.lastPolledDateTimeStamp = lastPolledDateTimeStamp;
	}

	public Date getLastPolledDateTimeStamp() {
		return lastPolledDateTimeStamp;
	}

	@Override
	public String getFinderData() {
		return DateFormatter.getDefaultInstance().formatDate(lastPolledDateTimeStamp);
	}
	
}
