package gov.va.med.esr.service.external.person;

import gov.va.med.esr.service.external.ExternalComponent;

import java.util.Date;

public class HardshipInfo extends ExternalComponent {

	private static final long serialVersionUID = -5163372955584400861L;
	
    /**
     * Hardship Indicator is defined as the indicator that identifies that the
     * veteran has a hardship applied. Values are YES/NO
     * ZMT (1)(MT)/13/Z10
     */
    private Boolean           hardshipGranted      = null;

    /**
     * Hardship Review Date is defined as the date the hardship should be
     * reviewed. Date must be precise
     * ZMT (1)(MT)/14/Z10
     */
    private Date              reviewDate           = null;

    /**
     * Hardship effective date is defined as the date when the hardship is
     * effective.Date must be precise
     * ZMT (1)(MT)/24/Z10
     */
    private Date              effectiveDate        = null;

    //ZMT (1)(MT)/23/Z10
    private String        siteGrantingHardship = null;

    /**
     * Hardship reason is defined as a reason this person has been granted a
     * hardship.
     * ZMT (1)(MT)/29/Z10
     */
    private String            reason               = null;

	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public Boolean getHardshipGranted() {
		return hardshipGranted;
	}

	public void setHardshipGranted(Boolean hardshipGranted) {
		this.hardshipGranted = hardshipGranted;
	}

	public String getReason() {
		return reason;
	}

	public void setReason(String reason) {
		this.reason = reason;
	}

	public Date getReviewDate() {
		return reviewDate;
	}

	public void setReviewDate(Date reviewDate) {
		this.reviewDate = reviewDate;
	}

	public String getSiteGrantingHardship() {
		return siteGrantingHardship;
	}

	public void setSiteGrantingHardship(String siteGrantingHardship) {
		this.siteGrantingHardship = siteGrantingHardship;
	}

}
