package gov.va.med.esr.service.external.person;

import gov.va.med.esr.service.external.person.collections.DependentFinancialsCollection;
import gov.va.med.esr.service.external.person.collections.SpouseFinancialsCollection;

import java.math.BigDecimal;
import java.util.Date;


public class FinancialStatementInfo extends BaseFinancialInfo {


	/**
	 * 
	 */
	private static final long serialVersionUID = -6885266732571039949L;

	/**
	 * Married last calendar year is defined as an Indicator of whether veteran
	 * was married during last calendar year Yes/No
	 * ZIR/2/Z10
	 */
	private Boolean marriedLastCalendarYear = Boolean.FALSE;

	/**
	 * Dollar amount contributed to spousal support is defined as the dollar
	 * amount paid in spouse support if the spouse did not reside with the
	 * veteran last calendar year, which is the Income year reported. Dollar
	 * amount between 0 and 999999999, 2 Decimal Digits
	 * ZIR/4/Z10
	 */
	private BigDecimal contributionToSpouse = null;

	/**
	 * Number of dependent children is defined as the number of qualifying
	 * dependent children this veteran has. This number is derived based on the
	 * dependents DOB
	 * ZIR/10/Z10
	 */
	private Integer numberOfDependentChildren = null;


	private SpouseFinancialsCollection spouseFinancialsList;

	private DependentFinancialsCollection dependentFinancialsList;
	private Integer inpatientDays;
	private Integer outpatientDays;
	private Date lastVisitDate;
	private Date vamcReportDate;
	
	private Boolean spousalSupportInd;
	
 
	public Boolean getMarriedLastCalendarYear() {
		return this.marriedLastCalendarYear;
	}

	public void setMarriedLastCalendarYear(Boolean marriedLastCalendarYear) {
		this.marriedLastCalendarYear = marriedLastCalendarYear;
	}

	public BigDecimal getContributionToSpouse() {
		return this.contributionToSpouse;
	}

	public void setContributionToSpouse(BigDecimal contributionToSpouse) {
		this.contributionToSpouse = contributionToSpouse;
	}

	public Integer getNumberOfDependentChildren() {
		return this.numberOfDependentChildren;
	}

	public void setNumberOfDependentChildren(Integer numberOfDependentChildren) {
		this.numberOfDependentChildren = numberOfDependentChildren;
	}
	public void setSpouseFinancialsList(SpouseFinancialsCollection spouseFinancialsList) {
		this.spouseFinancialsList = spouseFinancialsList;
	}

	public SpouseFinancialsCollection getSpouseFinancialsList() {
        return this.spouseFinancialsList;
	}
	public DependentFinancialsCollection getDependentFinancialsList() {
		return this.dependentFinancialsList;
	}

	public void setDependentFinancialsList(DependentFinancialsCollection dependentFinancialsList) {
		 this.dependentFinancialsList=dependentFinancialsList;
	}

	public Integer getInpatientDays() {
		return inpatientDays;
	}

	public void setInpatientDays(Integer inpatientDays) {
		this.inpatientDays = inpatientDays;
	}

	public Integer getOutpatientDays() {
		return outpatientDays;
	}

	public void setOutpatientDays(Integer outpatientDays) {
		this.outpatientDays = outpatientDays;
	}

	public Date getLastVisitDate() {
		return lastVisitDate;
	}

	public void setLastVisitDate(Date lastVisitDate) {
		this.lastVisitDate = lastVisitDate;
	}

	public Date getVamcReportDate() {
		return vamcReportDate;
	}

	public void setVamcReportDate(Date vamcReportDate) {
		this.vamcReportDate = vamcReportDate;
	}

	public Boolean getSpousalSupportInd() {
		return spousalSupportInd;
	}

	public void setSpousalSupportInd(Boolean spousalSupportInd) {
		this.spousalSupportInd = spousalSupportInd;
	}
	
	
}
