/********************************************************************
 ********************************************************************/


package gov.va.med.esr.service.external.person;

import gov.va.med.esr.service.external.ExternalComponent;

/**
 * Summary information regarding an individual's
 * Eligibility and Enrollment (EE) data.
 * 
 * Created Dec 18, 2006 8:17:33 AM
 * @author DNS   BOHMEG
 */
public class EligibilitySummary extends ExternalComponent {
	/**
	 * 
	 */
	private static final long serialVersionUID = -4545464626028800500L;
	private String claimFolderNumber;
	private String fathersName;
	private String mothersName;
	private String primaryEligibilityCode;
	private String lastServiceBranchCode;
	private String lastServiceNumber;
	private Boolean serviceConnected;
	private Integer serviceConnectedPercentage;
	private String lastServiceEntryDate; // String allows for imprecise dates
	private String lastServiceSeparationDate; // String allows for imprecise dates
	private String periodOfServiceCode;
	private Boolean POWStatusIndicated;
	private String eligibilityLastModifiedBy;
	private String dateOfDeathReportingStationNumber;
	private String dateOfDeathSourceOfNotificationCode;
	private String dateOfDeathLastModifiedDate;
	
	/**
	 * @return Returns the claimFolderNumber.
	 */
	public String getClaimFolderNumber() {
		return claimFolderNumber;
	}
	/**
	 * @param claimFolderNumber The claimFolderNumber to set.
	 */
	public void setClaimFolderNumber(String claimFolderNumber) {
		this.claimFolderNumber = claimFolderNumber;
	}
	/**
	 * @return Returns the dateOfDeathReportingStationNumber.
	 */
	public String getDateOfDeathReportingStationNumber() {
		return dateOfDeathReportingStationNumber;
	}
	
	/**
	 * @param dateOfDeathReportingStationNumber The dateOfDeathReportingStationNumber to set.
	 */
	public void setDateOfDeathReportingStationNumber(
			String dateOfDeathReportingStationNumber) {
		this.dateOfDeathReportingStationNumber = dateOfDeathReportingStationNumber;
	}
	/**
	 * @return Returns the eligibilityLastModifiedBy.
	 */
	public String getEligibilityLastModifiedBy() {
		return eligibilityLastModifiedBy;
	}
	/**
	 * @param eligibilityLastModifiedBy The eligibilityLastModifiedBy to set.
	 */
	public void setEligibilityLastModifiedBy(String eligibilityLastModifiedBy) {
		this.eligibilityLastModifiedBy = eligibilityLastModifiedBy;
	}
	/**
	 * @return Returns the fathersName.
	 */
	public String getFathersName() {
		return fathersName;
	}
	/**
	 * @param fathersName The fathersName to set.
	 */
	public void setFathersName(String fathersName) {
		this.fathersName = fathersName;
	}
	/**
	 * @return Returns the lastServiceBranchCode.
	 */
	public String getLastServiceBranchCode() {
		return lastServiceBranchCode;
	}
	/**
	 * @param lastServiceBranchCode The lastServiceBranchCode to set.
	 */
	public void setLastServiceBranchCode(String lastServiceBranchCode) {
		this.lastServiceBranchCode = lastServiceBranchCode;
	}
	/**
	 * @return Returns the lastServiceNumber.
	 */
	public String getLastServiceNumber() {
		return lastServiceNumber;
	}
	/**
	 * @param lastServiceNumber The lastServiceNumber to set.
	 */
	public void setLastServiceNumber(String lastServiceNumber) {
		this.lastServiceNumber = lastServiceNumber;
	}
	/**
	 * @return Returns the mothersName.
	 */
	public String getMothersName() {
		return mothersName;
	}
	/**
	 * @param mothersName The mothersName to set.
	 */
	public void setMothersName(String mothersName) {
		this.mothersName = mothersName;
	}
	/**
	 * @return Returns the periodOfServiceCode.
	 */
	public String getPeriodOfServiceCode() {
		return periodOfServiceCode;
	}
	/**
	 * @param periodOfServiceCode The periodOfServiceCode to set.
	 */
	public void setPeriodOfServiceCode(String periodOfServiceCode) {
		this.periodOfServiceCode = periodOfServiceCode;
	}
	/**
	 * @return Returns the pOWStatusIndicated.
	 */
	public Boolean getPOWStatusIndicated() {
		return POWStatusIndicated;
	}
	/**
	 * @param statusIndicated The pOWStatusIndicated to set.
	 */
	public void setPOWStatusIndicated(Boolean statusIndicated) {
		POWStatusIndicated = statusIndicated;
	}
	/**
	 * @return Returns the primaryEligibilityCode.
	 */
	public String getPrimaryEligibilityCode() {
		return primaryEligibilityCode;
	}
	/**
	 * @param primaryEligibilityCode The primaryEligibilityCode to set.
	 */
	public void setPrimaryEligibilityCode(String primaryEligibilityCode) {
		this.primaryEligibilityCode = primaryEligibilityCode;
	}
	/**
	 * @return Returns the serviceConnected.
	 */
	public Boolean getServiceConnected() {
		return serviceConnected;
	}
	/**
	 * @param serviceConnected The serviceConnected to set.
	 */
	public void setServiceConnected(Boolean serviceConnected) {
		this.serviceConnected = serviceConnected;
	}
	/**
	 * @return Returns the lastServiceEntryDate.
	 */
	public String getLastServiceEntryDate() {
		return lastServiceEntryDate;
	}
	/**
	 * @param lastServiceEntryDate The lastServiceEntryDate to set.
	 */
	public void setLastServiceEntryDate(String lastServiceEntryDate) {
		this.lastServiceEntryDate = lastServiceEntryDate;
	}
	/**
	 * @return Returns the lastServiceSeparationDate.
	 */
	public String getLastServiceSeparationDate() {
		return lastServiceSeparationDate;
	}
	/**
	 * @param lastServiceSeparationDate The lastServiceSeparationDate to set.
	 */
	public void setLastServiceSeparationDate(String lastServiceSeparationDate) {
		this.lastServiceSeparationDate = lastServiceSeparationDate;
	}
	/**
	 * @return Returns the dateOfDeathLastModifiedDate.
	 */
	public String getDateOfDeathLastModifiedDate() {
		return dateOfDeathLastModifiedDate;
	}
	/**
	 * @param dateOfDeathLastModifiedDate The dateOfDeathLastModifiedDate to set.
	 */
	public void setDateOfDeathLastModifiedDate(String dateOfDeathLastModifiedDate) {
		this.dateOfDeathLastModifiedDate = dateOfDeathLastModifiedDate;
	}
	/**
	 * @return Returns the dateOfDeathSourceOfNotificationCode.
	 */
	public String getDateOfDeathSourceOfNotificationCode() {
		return dateOfDeathSourceOfNotificationCode;
	}
	/**
	 * @param dateOfDeathSourceOfNotificationCode The dateOfDeathSourceOfNotificationCode to set.
	 */
	public void setDateOfDeathSourceOfNotificationCode(
			String dateOfDeathSourceOfNotificationCode) {
		this.dateOfDeathSourceOfNotificationCode = dateOfDeathSourceOfNotificationCode;
	}
	/**
	 * @return Returns the serviceConnectedPercentage.
	 */
	public Integer getServiceConnectedPercentage() {
		return serviceConnectedPercentage;
	}
	/**
	 * @param serviceConnectedPercentage The serviceConnectedPercentage to set.
	 */
	public void setServiceConnectedPercentage(Integer serviceConnectedPercentage) {
		this.serviceConnectedPercentage = serviceConnectedPercentage;
	}
}
