package gov.va.med.esr.service.external.person;

import java.math.BigDecimal;

public class DependentFinancialsInfo extends RelationFinancialsInfo {


	private static final long serialVersionUID = -404465160945675402L;

	
	private DependentInfo dependentInfo = null;
	
	//ZIC(Dep.)/1/Z10
	//private String 			  relationShipType;
	
	//ZIR(Dep.)/6/Z10
	private Boolean           incapableOfSelfSupport     = null;

	//ZIR(Dep.)/7/Z10
	private Boolean           contributedToSupport       = null;

    /**
     * Child has income is defined as an Indicator Yes/No the child had income
     * during last calendar year. Income payable to another person as guardian
     * or custodian of the child is considered to be the child's income.
     * ZIR(Dep.)/8/Z10
     */
    private Boolean           hasIncome                  = null;
    /**
     * Dollar amount contributed to spousal or dependent support.
     * 
     */
    private BigDecimal        amountContributedToSupport = null;

    /**
     * Income available is defined, as an Indicator Yes/No the child's income
     * was available to the veteran. The child's income is deemed to be
     * available if it can be used to pay expenses of the veteran's household.
     * For example, a Social Security check payable to the veteran's estranged
     * spouse as custodian of the child was probable not available to the
     * veteran. On the other hand, a Social Security check on behalf of the
     * child payable to someone living in the veteran's household was probably
     * available.
     * ZIR(Dep.)/9/Z10
     */
    private Boolean           incomeAvailableToPatient   = null;

    /**
     * Dependent child school indicator is defined as an indicator If the child
     * is between the ages of 18 and 23 indicate Yes/No if they attended school
     * last calendar year
     * ZIR(Dep.)/14/Z10
     */
    private Boolean           attendedSchool             = null;
    
    
    
    public DependentInfo getDependentInfo() {
		return dependentInfo;
	}

	public void setDependentInfo(DependentInfo dependentInfo) {
		this.dependentInfo = dependentInfo;
	}

	public Boolean getIncapableOfSelfSupport() {
        return this.incapableOfSelfSupport;
    }

    public void setIncapableOfSelfSupport(Boolean incapableOfSelfSupport) {
        this.incapableOfSelfSupport = incapableOfSelfSupport;
    }
    public Boolean getContributedToSupport() {
        return this.contributedToSupport;
    }

    public void setContributedToSupport(Boolean contributedToSupport) {
        this.contributedToSupport = contributedToSupport;
    }

    public BigDecimal getAmountContributedToSupport() {
        return amountContributedToSupport;
    }

    public void setAmountContributedToSupport(
            BigDecimal amountContributedToSupport) {
        this.amountContributedToSupport = amountContributedToSupport;
    }

    public Boolean getHasIncome() {
        return this.hasIncome;
    }

    public void setHasIncome(Boolean hasIncome) {
        this.hasIncome = hasIncome;
    }

    public Boolean getIncomeAvailableToPatient() {
        return this.incomeAvailableToPatient;
    }

    public void setIncomeAvailableToPatient(Boolean incomeAvailableToPatient) {
        this.incomeAvailableToPatient = incomeAvailableToPatient;
    }

    public Boolean getAttendedSchool() {
        return this.attendedSchool;
    }

    public void setAttendedSchool(Boolean attendedSchool) {
        this.attendedSchool = attendedSchool;
    }



	

}
