package gov.va.med.esr.service.external.person;

import gov.va.med.esr.service.external.ExternalComponent;

import java.util.Date;

public class DeathRecondInfo extends ExternalComponent {

	private static final long serialVersionUID = -3563736013605178270L;

	/**
	 * Date of death is defined as the deceased date for the individual. DOD
	 * cannot be in the future and DOD cannot be prior to Date of birth
	 * ZPD/9/Z05
	 */
	private String deathDate = null;

	/**
	 * Lazarus date is defined as the date the date of death was removed via a
	 * Lazarus transmission
	 */
	//private String lazarusDate = null;

	/**
	 * Date of Death report date is defined as the date that the DOD is reported
	 * or updated.Maps to Reeme date of death last updated
	 * ZPD/32/Z05
	 */
	private Date deathReportDate = null;

	/**
	 * Source of notification is defined as the source of the DOD being added or
	 * source of DOD removal. The acceptable choices are: 1 Next of
	 * Kin/Family/Friend 2 Inpatient at VAMC 3 VBA 4 VA Insurance 5 NCA 6 SSA 7
	 * Entered in Error 8 Other
	 * ZPD/31/Z05
	 */
	private String dataSource = null;

	/**
	 * Site that sent the death data
	 */
	private String facilityReceived = null;

	private Date deathLastModified; // keep separate from audit columns

	public String getDataSource() {
		return dataSource;
	}

	public void setDataSource(String dataSource) {
		this.dataSource = dataSource;
	}

	public String getDeathDate() {
		return deathDate;
	}

	public void setDeathDate(String deathDate) {
		this.deathDate = deathDate;
	}

	public Date getDeathLastModified() {
		return deathLastModified;
	}

	public void setDeathLastModified(Date deathLastModified) {
		this.deathLastModified = deathLastModified;
	}

	public Date getDeathReportDate() {
		return deathReportDate;
	}

	public void setDeathReportDate(Date deathReportDate) {
		this.deathReportDate = deathReportDate;
	}

	public String getFacilityReceived() {
		return facilityReceived;
	}

	public void setFacilityReceived(String facilityReceived) {
		this.facilityReceived = facilityReceived;
	}

	/**
	public String getLazarusDate() {
		return lazarusDate;
	}

	public void setLazarusDate(String lazarusDate) {
		this.lazarusDate = lazarusDate;
	}
	**/

}
