package gov.va.med.esr.service.external.person;

import gov.va.med.esr.service.external.ExternalComponent;
import gov.va.med.esr.service.external.person.collections.CDConditionCollection;
import gov.va.med.esr.service.external.person.collections.CDDiagnosisCollection;
import gov.va.med.esr.service.external.person.collections.CDProcedureCollection;

import java.util.Date;

public class CatastrophicDisabilityInfo extends ExternalComponent {


	private static final long serialVersionUID = 795966934387340220L;

	/**
     * Review date is defined as the date of the Catastrophically Disabled
     * evaluation. Either by medical record or by physical exam.
     * ZCD/2/Z11
     */
    private Date reviewDate = null;

    
    private Date decisionDate = null;

    //ZCD/14/Z11
    private Date veteranRequestedCDReviewDate = null;
    
    //ZCD/15/Z11
    private Date facilityInitiatedCDReviewDate = null;
    
    //ZCD/16/Z11
    private Date veteranWasNotifiedCDDate = null;
    
    //ZCD/4/Z11
    private String determinationFacility = null;
    /**
     * Decided by is defined as the name of the Chief of Staff or Designee
     * making the Catastrophically Disabled decision. Free text.
     * ZCD/3/Z11
     */
    private String determinedBy = null;

    /**
     * Determination method is defined as the method used to perform
     * Catastrophically Disabled evaluation. Values include: Medical Record
     * Review, Physical Exam.
     * ZCD/6/Z11
     */
    private String determinationMethod = null;

    //ZCD/12/Z11
    private Boolean catastrophicallyDisabled = null; 
	
    //ZCD/7/Z11
    private CDDiagnosisCollection diagnoses = null;

    //ZCD/8/Z11  & //ZCD/9/Z11
    private CDProcedureCollection cdProcedures = null;

    //ZCD/10/Z11 & ZCD/11/Z11 * ZCD/13/Z11 
    private CDConditionCollection cdConditions = null;
    
    

	public Boolean getCatastrophicallyDisabled() {
		return catastrophicallyDisabled;
	}

	public void setCatastrophicallyDisabled(Boolean catastrophicallyDisabled) {
		this.catastrophicallyDisabled = catastrophicallyDisabled;
	}



	public Date getDecisionDate() {
		return decisionDate;
	}

	public void setDecisionDate(Date decisionDate) {
		this.decisionDate = decisionDate;
	}

	/**
	public DependentInfo[] getDependents() {
		return dependents;
	}

	public void setDependents(DependentInfo[] dependents) {
		this.dependents = dependents;
	}
	**/
	public String getDeterminationMethod() {
		return determinationMethod;
	}

	public void setDeterminationMethod(String determinationMethod) {
		this.determinationMethod = determinationMethod;
	}

	public String getDeterminedBy() {
		return determinedBy;
	}

	public void setDeterminedBy(String determinedBy) {
		this.determinedBy = determinedBy;
	}


	public CDConditionCollection getCdConditions() {
		return cdConditions;
	}

	public void setCdConditions(CDConditionCollection cdConditions) {
		this.cdConditions = cdConditions;
	}

	public CDProcedureCollection getCdProcedures() {
		return cdProcedures;
	}

	public void setCdProcedures(CDProcedureCollection cdProcedures) {
		this.cdProcedures = cdProcedures;
	}

	public CDDiagnosisCollection getDiagnoses() {
		return diagnoses;
	}

	public void setDiagnoses(CDDiagnosisCollection diagnoses) {
		this.diagnoses = diagnoses;
	}

	public Date getFacilityInitiatedCDReviewDate() {
		return facilityInitiatedCDReviewDate;
	}

	public void setFacilityInitiatedCDReviewDate(
			Date facilityInitiatedCDReviewDate) {
		this.facilityInitiatedCDReviewDate = facilityInitiatedCDReviewDate;
	}

	public Date getReviewDate() {
		return reviewDate;
	}

	public void setReviewDate(Date reviewDate) {
		this.reviewDate = reviewDate;
	}

	/**
	public SpouseInfo getSpouse() {
		return spouse;
	}

	public void setSpouse(SpouseInfo spouse) {
		this.spouse = spouse;
	}**/

	public Date getVeteranRequestedCDReviewDate() {
		return veteranRequestedCDReviewDate;
	}

	public void setVeteranRequestedCDReviewDate(Date veteranRequestedCDReviewDate) {
		this.veteranRequestedCDReviewDate = veteranRequestedCDReviewDate;
	}

	public Date getVeteranWasNotifiedCDDate() {
		return veteranWasNotifiedCDDate;
	}

	public void setVeteranWasNotifiedCDDate(Date veteranWasNotifiedCDDate) {
		this.veteranWasNotifiedCDDate = veteranWasNotifiedCDDate;
	}

	public String getDeterminationFacility() {
		return determinationFacility;
	}

	public void setDeterminationFacility(String determinationFacility) {
		this.determinationFacility = determinationFacility;
	}


}
