package gov.va.med.esr.service.external.person;

import gov.va.med.esr.service.external.ExternalComponent;

public class CDConditionInfo extends ExternalComponent {

	private static final long serialVersionUID = 1017642479049186702L;

	/**
	 * CD condition is determined if he/she has one of the following conditions:
	 * Dependent in three or more ADLs, with at least three of the dependencies
	 * being permanent, using the Katz Scale. A score of 10 or lower using the
	 * Folstein Mini-Mental State Examination. A score of 2 or lower on at least
	 * 4 of the 13 motor items using the Functional Independence Measure (FIM) A
	 * score of 30 or lower using the Global Assessment of Functions in (GAF)
	 * Valid values for this attribute are: (FOLS)-FOLSTEIN MINI-MENTAL STATE
	 * EXAM (FIM)-FUNCTIONAL INDEPENDENCE MEASURE (GAF)-GLOBAL ASSESSMENT OF
	 * FUNCTIONING (KATZ)-KATZ SCALE.
	 * ZCD/10/Z11
	 */
	private String condition = null;

	/**
	 * Score is based on the following and contingent on which CD condition was
	 * selected (FOLS, FIM, GAF, or KATZ). Each one will have a score associated
	 * with it. Folstein Mini-Mental State Examination (FOLS) is a number between
	 * 0 - 30, on the Folstein.Mini-Mental State Examination (MMSE). Functional
	 * Independence Measure:The FIM contains 18 measures in 6 domains. The 13
	 * MOTOR ITEMS are in 4 domains:- self-care,- sphincter control, - transfers,
	 * and- locomotion.The value in this field is based on the number of MOTOR
	 * items for which the veteran received a score of 2 or lower. FIMS Score is
	 * 0-13.The Katz Index of Activities of Daily Living (ADLs) assigns a number
	 * from 1 to 3 in each of 6 activities. 1 is dependent, 2 is an intermediate
	 * limitation, and 3 is independent. The Katz Index may be used to determine
	 * whether a veteran is catastrophically disabled.This field must contain the
	 * number of permanent ADLs for which the veteran received a score of 1
	 * (dependent). It is NOT the overall score on theKATZ test (which can range
	 * from 0 to 6.) GAF score is a number between 1 and 100.
	 * ZCD/11/Z11
	 */
	private Integer score;

	/**
	 * Permanent Indicator indicates if the specific CD condition is a permanent
	 * one. This is a set of codes: 1- FOR PERMANENT; 2- FOR NOT PERMANENT; 3-
	 * FOR UNKNOWN
	 * ZCD/13/Z11
	 */
	private Boolean permanentIndicator = null;

	public String getCondition() {
		return condition;
	}

	public void setCondition(String condition) {
		this.condition = condition;
	}

	public Boolean getPermanentIndicator() {
		return permanentIndicator;
	}

	public void setPermanentIndicator(Boolean permanentIndicator) {
		this.permanentIndicator = permanentIndicator;
	}

	public Integer getScore() {
		return score;
	}

	public void setScore(Integer score) {
		this.score = score;
	}
}
