/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.service.external.demographics;

import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Set;

import javax.ejb.CreateException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;

import gov.va.med.caip.client.businessdelegate.BusinessDelegateInfo;

import gov.va.med.esr.service.external.ESRException;
import gov.va.med.esr.service.external.ExternalServiceImpl;
import gov.va.med.esr.service.external.demographics.ejb.DemographicsServiceHome;
import gov.va.med.esr.service.external.demographics.ejb.RemoteDemographicsService;

/**
 * Business delegate, suitable for HeatheVet CAIP usage.
 * 
 * Created Dec 23, 2005 11:58:10 AM
 * 
 * @author DNS   BOHMEG
 */
public class DemographicsServiceImpl extends ExternalServiceImpl implements
		DemographicsService {
	/**
	 * 
	 */
	private static final long serialVersionUID = -4415928048589042271L;

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.esr.service.external.demographics.DemographicsService#notifyOfDemographicsChange(gov.va.med.esr.service.external.demographics.DemographicsChangeSummary)
	 */
	public void notifyOfDemographicsChange(
			DemographicsChangeSummary changeSummary) throws ESRException {
		// TODO: verify changeSummary contains a valid VPID

		validate(changeSummary);

		// Uncomment this for CAIP-JMS usage
		/*
		 * sendMessage(changeSummary,
		 * DemographicsChangeSummary.DEFAULT_MESSAGE_TYPE,
		 * DemographicsChangeSummary.DEFAULT_MESSAGE_INITIATER);
		 */

		try {
			((RemoteDemographicsService) getEJB())
					.notifyOfDemographicsChange(changeSummary);
		} catch (Exception e) {
			throw new ESRException("Unable to handle demographics change", e);
		}
	}

	private void validate(DemographicsChangeSummary changeSummary) throws ESRException {
		DemographicsChangeEvent event = null;
		Set events = null;
		DemographicsChangeType[] changeTypesThatRequireEntityKeys = new DemographicsChangeType[] {
				DemographicsChangeType.ADDRESS_CHANGE,
				DemographicsChangeType.GUARDIAN_INFO_CHANGE,
				DemographicsChangeType.PHONE_CHANGE,
				DemographicsChangeType.EMAIL_CHANGE,
				DemographicsChangeType.PERSON_RELATION_SSN_VALIDATION_INFO_CHANGE };
		for (int i = 0; i < changeTypesThatRequireEntityKeys.length; i++) {
			if (changeSummary
					.containsChangeEventsByType(changeTypesThatRequireEntityKeys[i])) {
				events = changeSummary
						.getChangeEventsByType(changeTypesThatRequireEntityKeys[i]);
				Iterator itr = events != null ? events.iterator() : null;
				while (itr != null && itr.hasNext()) {
					event = (DemographicsChangeEvent) itr.next();
					if (event.getEntityKey() == null) {
						throw new ESRException(
								"Illegal DemographicsChangeEvent.  This type requires an EntityKey: "
										+ changeTypesThatRequireEntityKeys[i]);
					}
				}
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.esr.service.external.ExternalServiceImpl#getBusinessDelegateInterfaceInfo()
	 */
	public BusinessDelegateInfo getBusinessDelegateInterfaceInfo() {
		return new DemographicsServiceInfo();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.esr.service.external.ExternalServiceImpl#createEJB(javax.ejb.EJBHome)
	 */
	protected EJBObject createEJB(EJBHome home) throws RemoteException,
			CreateException {
		return ((DemographicsServiceHome) home).create();
	}
}
