/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.service.external.demographics;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import gov.va.med.esr.service.external.ExternalComponent;
import gov.va.med.esr.service.external.person.EntityKey;
import gov.va.med.esr.service.external.person.VPIDEntityKey;

/**
 * Initial javadoc for class DemographicsChangeSummary. TODO - Add content here
 * 
 * Created Dec 23, 2005 10:54:20 AM
 * 
 * @author DNS   BOHMEG
 */
public class DemographicsChangeSummary extends ExternalComponent {
	public static final String DEFAULT_MESSAGE_INITIATER = "PSD demographics change";

	public final static String DEFAULT_MESSAGE_TYPE = "crossApplication.notification.demographicsChange";

	/**
	 * 
	 */
	private static final long serialVersionUID = 493174924918166719L;

	private VPIDEntityKey vpid;

	private Set changeEvents;

	/**
	 * @return Returns the vpid.
	 */
	public VPIDEntityKey getVpid() {
		return vpid;
	}

	public DemographicsChangeSummary(VPIDEntityKey vpid) {
		this.vpid = vpid;
	}

	public DemographicsChangeSummary(VPIDEntityKey vpid, Set changeEvents) {
		this(vpid);
		this.changeEvents = changeEvents;
	}

	public Set getChangeEvents() {
		return changeEvents;
	}

	public Iterator getChangeEventsIterator() {
		return changeEvents != null ? changeEvents.iterator()
				: Collections.EMPTY_SET.iterator();
	}

	public synchronized void addChangeEvent(DemographicsChangeEvent changeEvent) {
		if (changeEvent != null) {
			changeEvents = changeEvents != null ? changeEvents : new HashSet();
			changeEvents.add(changeEvent);
		}
	}

	public boolean containsChangeEventsByType(DemographicsChangeType changeType) {
		return getChangeEventsByType(changeType).size() != 0;
	}

	public Set getEntityKeysByType(DemographicsChangeType changeType) {
		Set matches = getChangeEventsByType(changeType);
		Set keys = new HashSet();
		EntityKey key = null;
		for(Iterator itr = matches.iterator(); itr.hasNext();) {
			key = ((DemographicsChangeEvent) itr.next()).getEntityKey();
			if(key != null)
				keys.add(key);
		}
		return keys;
	}
	
	
	public Set getChangeEventsByType(DemographicsChangeType changeType) {
		Set matches = new HashSet();
		Iterator itr = getChangeEventsIterator();
		DemographicsChangeEvent current = null;
		while (itr.hasNext()) {
			current = (DemographicsChangeEvent) itr.next();
			if (current.getChangeType().equals(changeType))
				matches.add(current);
		}
		return matches;
	}
}
