package gov.va.med.esr.service.external;

import gov.va.med.esr.common.model.ee.RatedDisability;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.external.person.RatedDisabilityInfo;
import gov.va.med.esr.service.external.person.ServiceConnectionAwardInfo;
import gov.va.med.esr.service.external.person.collections.RatedDisabilityCollection;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;

public class ServiceConnectionAwardFactoryImpl implements ServiceConnectionAwardFactory {
		
	public ServiceConnectionAwardInfo buildServiceConnectionAward(Person person) {		
		
		ServiceConnectionAward scAward = person.getServiceConnectionAward();
		if ( scAward == null )
		{
			return null;
		}
		
		ServiceConnectionAwardInfo scaInfo = new ServiceConnectionAwardInfo();
		
		scaInfo.setServiceConnectedPercentage(scAward.getServiceConnectedPercentage());
		scaInfo.setServiceConnectedIndicator(scAward.getServiceConnectedIndicator());
		scaInfo.setCombinedServiceConnectedPercentageEffectiveDate(scAward.getCombinedServiceConnectedPercentageEffectiveDate() != null ? scAward.getCombinedServiceConnectedPercentageEffectiveDate().getStandardFormat():null);			
		scaInfo.setScReportDate(scAward.getModifiedOn());		
		scaInfo.setUnemployable(scAward.getUnemployable());
		scaInfo.setPermanentAndTotal(scAward.getPermanentAndTotal());
		
		scaInfo.setPermanentAndTotalEffectiveDate(scAward.getPermanentAndTotalEffectiveDate());
		if ( scAward.getAwardDate() != null)
		scaInfo.setAwardDate(scAward.getAwardDate().getStandardFormat());

		Set ratedDisabilities = scAward.getRatedDisabilities();
		
		if ( ratedDisabilities != null )
		{
			Iterator disablityItr = ratedDisabilities.iterator();
			RatedDisabilityInfo[] rdInfos = new RatedDisabilityInfo[ratedDisabilities.size()]; 
			
			int i=0;
			while (disablityItr.hasNext())
			{
				RatedDisabilityInfo rdInfo = new RatedDisabilityInfo();
				RatedDisability rd = (RatedDisability) disablityItr.next();
				rdInfo.setDisability(rd.getDisability()!=null?rd.getDisability().getName():null);
				rdInfo.setPercentage(rd.getPercentage());
				rdInfo.setServiceConnected(rd.isServiceConnected());
				rdInfo.setDiagnosticExtremity(rd.getDiagnosticExtremity() != null ?rd.getDiagnosticExtremity().getDescription():null);
				rdInfo.setOriginalEffectiveRatingDate(rd.getOriginalEffectiveRatingDate() != null ?rd.getOriginalEffectiveRatingDate().getStandardFormat():null);
				rdInfo.setRatingDate(rd.getRatingDate() != null ?rd.getRatingDate().getStandardFormat():null);
           //     rd.getDisability().getCode();
                //16 fields 
                rdInfo.setRecordModifiedDate(rd.getModifiedOn() != null? rd.getModifiedOn():null);
                rdInfo.setDisabilityCode(rd.getDisability() != null? rd.getDisability().getCode():null);
                //end 16 fields

				rdInfos[i] = rdInfo;
				i++;
			}
			
			if ( rdInfos != null && rdInfos.length > 0  )
			{
				scaInfo.setRatedDisabilities(new RatedDisabilityCollection(rdInfos));
			}
		}
		return scaInfo;
	}
	
}
