package gov.va.med.esr.service.external;

import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.ee.ConflictExperience;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.POWEpisode;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.external.person.CombatEpisodeInfo;
import gov.va.med.esr.service.external.person.ConflictExperienceInfo;
import gov.va.med.esr.service.external.person.MilitaryServiceEpisodeInfo;
import gov.va.med.esr.service.external.person.MilitaryServiceInfo;
import gov.va.med.esr.service.external.person.MilitaryServiceSiteRecordInfo;
import gov.va.med.esr.service.external.person.POWEpisodeInfo;
import gov.va.med.esr.service.external.person.PrisonerOfWarInfo;
import gov.va.med.esr.service.external.person.PurpleHeartInfo;
import gov.va.med.esr.service.external.person.collections.CombatEpisodeCollection;
import gov.va.med.esr.service.external.person.collections.ConflictExperienceCollection;
import gov.va.med.esr.service.external.person.collections.MilitaryServiceEpisodeCollection;
import gov.va.med.esr.service.external.person.collections.MilitaryServiceSiteRecordCollection;
import gov.va.med.esr.service.external.person.collections.POWEpisodeCollection;

import java.util.Iterator;
import java.util.Set;

public class MilitaryServiceFactoryImpl implements MilitaryServiceFactory {

	public MilitaryServiceInfo getMilitaryServiceInfo(Person person) {
		MilitaryService ms = person.getMilitaryService();
		if (ms == null)
			return null;

		MilitaryServiceInfo msInfo = new MilitaryServiceInfo();

		msInfo.setCombatVeteranEligibilityEndDate(ms
				.getCombatVeteranEligibilityEndDate());
		msInfo.setDisabilityRetirementIndicator(ms
				.getDisabilityRetirementIndicator());
		msInfo.setDischargeDueToDisability(ms.getDischargeDueToDisability());



		if (person.getShad() != null
				&& person.getShad().getShadIndicator() != null)
			msInfo.setShadIndicator(person.getShad().getShadIndicator()
					.toBoolean());

		//		CCR11632 added
		if(person.getMedalOfHonor() != null && person.getMedalOfHonor().getMhIndicator() != null){
			msInfo.setMedalofHonorIndicator(person.getMedalOfHonor().getMhIndicator());
		}
		if(person.getClassIIDentalApplicationDueBefore() != null){
			msInfo.setClassIIDentalApplicationDueBefore(person.getClassIIDentalApplicationDueBefore());
		}
		if(person.getEligibleForClassIIDental() != null){
			msInfo.setEligibleForClassIIDental(person.getEligibleForClassIIDental());
		}
		//End of CCR11632

		CombatEpisodeInfo[] combatEpisodes = getCombatEpisodes(ms
				.getCombatEpisodes());
		if (combatEpisodes != null && combatEpisodes.length > 0) {
			msInfo
					.setCombatEpisodes(new CombatEpisodeCollection(
							combatEpisodes));
		}
		MilitaryServiceSiteRecordInfo[] militaryServiceSiteRecords = getSiteReconds(ms
				.getMilitaryServiceSiteRecords());

		if (militaryServiceSiteRecords != null
				&& militaryServiceSiteRecords.length > 0) {
			msInfo
					.setMilitaryServiceSiteRecords(new MilitaryServiceSiteRecordCollection(
							militaryServiceSiteRecords));
		}

		return msInfo;

	}

	/***************************************************************************
	 * private static CombatServiceInfo[] getCombatServices(Set combatServices) {
	 *
	 * if (combatServices == null) return null;
	 *
	 * Iterator csIter = combatServices.iterator(); CombatServiceInfo[]
	 * combatServiceInfos = new CombatServiceInfo[combatServices .size()]; int i =
	 * 0; while (csIter.hasNext()) { CombatService cs = (CombatService)
	 * csIter.next(); CombatServiceInfo csInfo = new CombatServiceInfo(); csInfo
	 * .setCombatServiceSource(cs.getCombatServiceSource() != null ? cs
	 * .getCombatServiceSource().getCode() : null);
	 * csInfo.setPayEndDate(cs.getPayEndDate() != null ? cs
	 * .getPayEndDate().getStandardFormat() : null);
	 * csInfo.setPayStartDate(cs.getPayStartDate() != null ? cs
	 * .getPayStartDate().getStandardFormat() : null);
	 *
	 * if (cs.getCombatServiceLocation() != null) { CombatServiceLocationInfo
	 * cslInfo = new CombatServiceLocationInfo(); CombatServiceLocation csl =
	 * cs.getCombatServiceLocation();
	 * cslInfo.setIncludedLocations(csl.getIncludedLocations());
	 * cslInfo.setStartDate(csl.getStartDate());
	 * cslInfo.setEndDate(csl.getEndDate());
	 * csInfo.setCombatServiceLocationInfo(cslInfo); } combatServiceInfos[i] =
	 * csInfo; i++; } return combatServiceInfos; }
	 **************************************************************************/

	public CombatEpisodeInfo[] getCombatEpisodes(Set combatEpisodes) {
		if (combatEpisodes == null)
			return null;

		Iterator ceIter = combatEpisodes.iterator();
		CombatEpisodeInfo[] combatEpisodeInfos = new CombatEpisodeInfo[combatEpisodes
				.size()];
		int i = 0;
		while (ceIter.hasNext()) {
			CombatEpisode ce = (CombatEpisode) ceIter.next();
			CombatEpisodeInfo ceInfo = new CombatEpisodeInfo();

			ceInfo.setCombatPayType(ce.getCombatPayType() != null ? ce
					.getCombatPayType().getDescription() : null);
			ceInfo.setOEFOIFSource(ce.getOEFOIFSource() != null ? ce
					.getOEFOIFSource().getCode() : null);
			ceInfo
					.setOEFOIFStationNumber(ce.getOEFOIFStationNumber() != null ? ce
							.getOEFOIFStationNumber().getStationNumber()
							: null);
			ceInfo.setConflictLocation(ce.getConflictLocation() != null ? ce
					.getConflictLocation().getName() : null);
			ceInfo.setStartDate(ce.getStartDate() != null ? ce.getStartDate()
					.getStandardFormat() : null);
			ceInfo.setEndDate(ce.getEndDate() != null ? ce.getEndDate()
					.getStandardFormat() : null);

			combatEpisodeInfos[i] = ceInfo;
			i++;
		}
		return combatEpisodeInfos;
	}

	public MilitaryServiceSiteRecordInfo[] getSiteReconds(
			Set militaryServiceSiteRecords) {

		if (militaryServiceSiteRecords == null)
			return null;

		MilitaryServiceSiteRecordInfo[] siteReconrds = new MilitaryServiceSiteRecordInfo[militaryServiceSiteRecords
				.size()];
		Iterator siteRecordsItr = militaryServiceSiteRecords.iterator();

		int i = 0;
		while (siteRecordsItr.hasNext()) {
			MilitaryServiceSiteRecordInfo srInfo = new MilitaryServiceSiteRecordInfo();
			MilitaryServiceSiteRecord sr = (MilitaryServiceSiteRecord) siteRecordsItr
					.next();

			srInfo.setSite(sr.getSite() != null ? sr.getSite()
					.getSiteNumberAndName() : null);
			srInfo.setServicePeriod(sr.getServicePeriod() != null ? sr
					.getServicePeriod().getName() : null);
			// srInfo.setFilipinoVeteranProof(sr.getFilipinoVeteranProof()!=
			// null ? sr.getFilipinoVeteranProof().getCode():null);

			MilitaryServiceEpisodeInfo[] militaryServiceEpisodes = getMSEpisodes(sr
					.getMilitaryServiceEpisodes());

			if (militaryServiceEpisodes != null
					&& militaryServiceEpisodes.length > 0) {
				srInfo
						.setMilitaryServiceEpisodes(new MilitaryServiceEpisodeCollection(
								militaryServiceEpisodes));
			}


			ConflictExperienceInfo[] conflicts = getConflictExperiences(sr.getConflictExperiences());

			if ( conflicts != null && conflicts.length > 0 )
			{
				srInfo.setConflictExperiences(new ConflictExperienceCollection(conflicts));
			}



			siteReconrds[i] = srInfo;
			i++;
		}
		return siteReconrds;
	}

	public ConflictExperienceInfo[] getConflictExperiences(
			Set conflictExperiences) {
		if (conflictExperiences == null)
			return null;

		ConflictExperienceInfo[] ceInfos = new ConflictExperienceInfo[conflictExperiences.size()];

		Iterator ceItr = conflictExperiences.iterator();

		int i = 0;
		while (ceItr.hasNext()) {
			ConflictExperienceInfo ceInfo = new ConflictExperienceInfo();
			ConflictExperience ce = (ConflictExperience) ceItr.next();

			ceInfo.setStartDate(ce.getStartDate()!=null?ce.getStartDate().getStandardFormat():null);
			ceInfo.setEndDate(ce.getEndDate()!=null?ce.getEndDate().getStandardFormat():null);
			ceInfo.setConflictLocation(ce.getConflictLocation()!=null?ce.getConflictLocation().getName():null);
			ceInfos[i] = ceInfo;
			i++;
		}

		return ceInfos;
	}


	public MilitaryServiceEpisodeInfo[] getMSEpisodes(
			Set militaryServiceEpisodes) {
		if (militaryServiceEpisodes == null)
			return null;

		MilitaryServiceEpisodeInfo[] mseInfos = new MilitaryServiceEpisodeInfo[militaryServiceEpisodes
				.size()];

		Iterator mseItr = militaryServiceEpisodes.iterator();

		int i = 0;
		while (mseItr.hasNext()) {
			MilitaryServiceEpisodeInfo mseInfo = new MilitaryServiceEpisodeInfo();
			MilitaryServiceEpisode mse = (MilitaryServiceEpisode) mseItr.next();
			mseInfo.setServiceBranch(mse.getServiceBranch() != null ? mse
					.getServiceBranch().getDescription() : null);
			 mseInfo.setDischargeType(mse.getDischargeType() != null
			 ?mse.getDischargeType().getDescription():null);
			// mseInfo.setMilitaryServiceComponent(mse.getMilitaryServiceComponent()!=null
			// ?mse.getMilitaryServiceComponent().getCode():null);
			mseInfo.setServiceNumber(mse.getServiceNumber());
			mseInfo.setStartDate(mse.getStartDate() != null ? mse
					.getStartDate().getStandardFormat() : null);
			mseInfo.setEndDate(mse.getEndDate() != null ? mse.getEndDate()
					.getStandardFormat() : null);
			mseInfos[i] = mseInfo;
			i++;
		}

		return mseInfos;
	}

	public PrisonerOfWarInfo getPOWInfo(Person person) {
		PrisonerOfWar pow = person.getPrisonerOfWar();

		if (pow == null)
			return null;

		PrisonerOfWarInfo powInfo = new PrisonerOfWarInfo();
		// powInfo.setDateEntered(pow.getDateEntered());
		// powInfo.setIcn(pow.getIcn());
		powInfo.setPowIndicator(pow.getPowIndicator() != null ? pow
				.getPowIndicator().getName() : null);
		// powInfo.setUser(pow.getUser());

		Set episodes = pow.getEpisodes();
		if (episodes != null) {
			Iterator episodeItr = episodes.iterator();
			POWEpisodeInfo[] eInfos = new POWEpisodeInfo[episodes.size()];
			int i = 0;
			while (episodeItr.hasNext()) {
				POWEpisode episode = (POWEpisode) episodeItr.next();
				POWEpisodeInfo eInfo = new POWEpisodeInfo();

				eInfo.setCaptureDate(episode.getCaptureDate() != null ? episode
						.getCaptureDate().getStandardFormat() : null);
				eInfo.setDataSource(episode.getDataSource() != null ? episode
						.getDataSource().getDescription() : null);
				// eInfo.setDateEntered(episode.getDateEntered());
				//CCR 10410 EE Service: POW Document Type returns Code not Name
				eInfo.setDocumentType(episode.getDocumentType() != null ? episode
								.getDocumentType().getDescription(): null);
				// eInfo.setLocation(episode.getCampLocation() != null ?
				// episode.getCampLocation().getNameAndLocation():null);
				// eInfo.setNumberOfDaysInCaptivity(episode.getNumberOfDaysInCaptivity());
				eInfo.setReleaseDate(episode.getReleaseDate() != null ? episode
						.getReleaseDate().getStandardFormat() : null);
				eInfos[i] = eInfo;
				i++;
			}

			if (eInfos != null && eInfos.length > 0) {
				powInfo.setEpisodes(new POWEpisodeCollection(eInfos));
			}
		}
		return powInfo;
	}

	public PurpleHeartInfo getPurpleHeartInfo(Person person) {
		PurpleHeart ph = person.getPurpleHeart();

		if (ph == null)
			return null;

		PurpleHeartInfo phInfo = new PurpleHeartInfo();
		phInfo.setStatus(ph.getStatus() != null ? ph.getStatus()
				.getDescription() : null);
		return phInfo;
	}
}
