package gov.va.med.esr.service.external;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.external.person.ConsentInfo;
import gov.va.med.esr.service.external.person.EESummary;
import gov.va.med.esr.service.external.person.IVMCandidateInfo;
import gov.va.med.esr.service.external.person.IvmLetterCandidateInfo;
import gov.va.med.esr.service.external.person.IVMLetterInfo;
import gov.va.med.esr.service.external.person.IVMSummary;
import gov.va.med.esr.service.external.person.IncomeTestInfo;
import gov.va.med.esr.service.external.person.PersonInfo;
import gov.va.med.esr.service.external.person.SendIVMInfo;
import gov.va.med.fw.service.ServiceException;

public interface IVMSummaryFactory {

	public IVMCandidateInfo[] buildIVMCandidatesInfo(Date date) throws ServiceException;
	public IvmLetterCandidateInfo[] buildIvmLetterCandidatesInfo() throws ServiceException;
	public boolean updateIVMStatus(BigDecimal transactionId, String status) throws ServiceException;
	public PersonInfo applyPersonInfo(Person person, String requestor);
	public IVMSummary processIVMIncomeTest(Person person, Integer incomeYear, SendIVMInfo incomingIvmObj,IVMSummary ivmSummary,
			IVMLetterInfo incomingLetterObj);
}
