package gov.va.med.esr.service.external;

import java.util.Set;

import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.service.external.person.ConsentInfo;
import gov.va.med.esr.service.external.person.DependentInfo;
import gov.va.med.esr.service.external.person.EESummary;
import gov.va.med.esr.service.external.person.FinancialStatementInfo;
import gov.va.med.esr.service.external.person.IncomeTestInfo;
import gov.va.med.esr.service.external.person.SignatureImageInfo;
import gov.va.med.esr.service.external.person.SpouseInfo;
import gov.va.med.fw.service.ServiceException;

public interface FinancialsSummaryFactory {

	public  SignatureImageInfo[] buildSignatures(Person person);	
	public  IncomeTestInfo getIncomeTestInfo(Person person, Integer incomeYear,String requestor) throws ServiceException;	
	public  FinancialStatementInfo getFinancialStatement(Person person, Integer incomeYear);
	public  DependentInfo buildDependent(Dependent dependent);
	public  SpouseInfo buildSpouse(Spouse spouse) ;
	public void applyFinancialsInfo(Person person, EESummary eeSummary, Integer incomeYear,String requestor) throws ServiceException;
	public  ConsentInfo applyConsentInfo(Person person, Integer incomeYear); 
	public Set getVisitedSites(Person person)throws ServiceException;
}
