package gov.va.med.esr.service.external;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.external.person.EESummary;

import gov.va.med.esr.service.external.person.IVMSummary;
import gov.va.med.esr.service.external.person.MSSummary;
import gov.va.med.esr.service.external.person.SendIVMInfo;
import gov.va.med.esr.service.external.person.IVMLetterInfo;
import gov.va.med.fw.service.ServiceException;

public interface ExternalSummaryFactory  {


	//public  void applyCommonData(Person person, ExternalPerson result) ;
	public   EESummary buildEESummary(Person person, Integer incomeYear, String requestor)throws ServiceException;
    public   void buildEESummaryHistory(Person person,EESummary eeSummary, String categoryName, Date acaStart, Date acaEnd);
	public   MSSummary buildMSSummary(Person person);
    public   EESummary buildEDStatus(Person person);
    public   IVMSummary buildIVMCandidates(Date date);
    public 	 IVMSummary buildIvmLetterCandidates();
    public   IVMSummary updateIvmStatus(BigDecimal transactionId, String status);
    public   IVMSummary processIVMIncomeTest(Person person, Integer incomeYear, SendIVMInfo incomingIvmObj,
    		IVMLetterInfo incomingLetterObj);

}
