/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.service.external;

import java.io.Serializable;
import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.jms.ObjectMessage;

import gov.va.med.caip.client.businessdelegate.BusinessDelegateInfo;
import gov.va.med.caip.client.exceptions.CaipException;
import gov.va.med.caip.client.exceptions.CaipJMSUtilityException;
import gov.va.med.caip.client.location.ServiceFacadeJMS;
import gov.va.med.caip.client.location.ServiceFacadeRemoteEJB;
import gov.va.med.caip.client.utils.JMSUtilities;

/**
 * Base class for CAIP Business Delegates.
 * 
 * Created Dec 23, 2005 11:36:05 AM
 * 
 * @author DNS   BOHMEG
 */
public abstract class ExternalServiceImpl implements ExternalService {
	
    private static final long serialVersionUID = -1370346746640850300L; 
    private static final String MESSAGE_TYPE = "Message_Type";
	private static final String INITIATER = "Message_Initiater";
	
	private ServiceFacadeRemoteEJB caipFacadeForEJB;

	private ServiceFacadeJMS caipFacadeForJMS;
	
	protected synchronized EJBObject getEJB() throws RemoteException, CreateException {
		return createEJB(getEJBHome());
	}
	
	protected abstract EJBObject createEJB(EJBHome home) throws RemoteException, CreateException; 
	
	private EJBHome getEJBHome() {
		return caipFacadeForEJB.getEjbHomeReference();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.caip.client.businessdelegate.BusinessDelegate#getBusinessDelegateInterfaceInfo()
	 */
	public abstract BusinessDelegateInfo getBusinessDelegateInterfaceInfo();

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.caip.client.businessdelegate.BusinessDelegateRemoteEJB#setServiceFacade(gov.va.med.caip.client.location.ServiceFacadeRemoteEJB)
	 */
	public void setServiceFacade(ServiceFacadeRemoteEJB caipFacadeForEJB)
			throws CaipException {
		this.caipFacadeForEJB = caipFacadeForEJB;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.caip.client.businessdelegate.BusinessDelegateJMS#setServiceFacade(gov.va.med.caip.client.location.ServiceFacadeJMS)
	 */
	public void setServiceFacade(ServiceFacadeJMS caipFacadeForJMS)
			throws CaipException {
		this.caipFacadeForJMS = caipFacadeForJMS;
	}

	private ObjectMessage createObjectMessage() throws ESRException {
		//TODO: Note that for now this does not support the creation of a TriggerEvent!
		
		try {
			return JMSUtilities.createObjectMessage(caipFacadeForJMS
					.getSession());
		} catch (CaipJMSUtilityException e) {
			throw new ESRException("Unable to create JMS Message", e);
		}
	}

	public void sendMessage(Serializable payload, String messageType, String initiater, String destinationKey)
			throws ESRException {
		try {
			ObjectMessage msg = createObjectMessage();
			msg.setObject(payload);
			msg.setStringProperty(MESSAGE_TYPE, messageType);
			msg.setStringProperty(INITIATER, initiater);
			msg.setStringProperty("Destination_Key", destinationKey); // used for MDB Selector
			JMSUtilities.sendMessage(caipFacadeForJMS.getConnection(),
					caipFacadeForJMS.getSession(), caipFacadeForJMS
							.getDestination(), msg);
		} catch (Exception e) {
			throw new ESRException("Unable to send JMS Message", e);
		}
	}
}
