package gov.va.med.esr.service.external;

import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.insurance.Medicare;
import gov.va.med.esr.common.model.insurance.PrivateInsurance;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.ConfidentialAddressCategory;
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PreferredFacility;
import gov.va.med.esr.common.model.person.PreferredLanguage;
import gov.va.med.esr.common.model.person.Race;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.service.PreferredFacilityService;
import gov.va.med.esr.service.external.person.AddressInfo;
import gov.va.med.esr.service.external.person.AssociationInfo;
import gov.va.med.esr.service.external.person.BaseAddressInfo;
import gov.va.med.esr.service.external.person.ContactInfo;
import gov.va.med.esr.service.external.person.DeliveryPreferenceInfo;
import gov.va.med.esr.service.external.person.DemographicInfo;
import gov.va.med.esr.service.external.person.EESummary;
import gov.va.med.esr.service.external.person.EmailInfo;
import gov.va.med.esr.service.external.person.EmploymentInfo;
import gov.va.med.esr.service.external.person.InsuranceInfo;
import gov.va.med.esr.service.external.person.PhoneInfo;
import gov.va.med.esr.service.external.person.RelationInfo;
import gov.va.med.esr.service.external.person.SSNInfo;
import gov.va.med.esr.service.external.person.SensitivityInfo;
import gov.va.med.esr.service.external.person.collections.AddressCollection;
import gov.va.med.esr.service.external.person.collections.ConfidentialAddressCategoryCollection;
import gov.va.med.esr.service.external.person.collections.EmailCollection;
import gov.va.med.esr.service.external.person.collections.PhoneCollection;
import gov.va.med.esr.service.external.person.collections.RaceCollection;
import gov.va.med.esr.service.external.person.collections.SSNCollection;
import gov.va.med.fw.hl7.segment.IN1;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DemographicSummaryFactoryImpl  implements DemographicSummaryFactory{
	public static final String CONTACT_METHOD_TYPE_CODE = "08";
	private PreferredFacilityService preferredFacilityService = null;

	public void applyDemographicsInfo (Person person, EESummary eeSummary){
		DemographicInfo demographicInfo = new DemographicInfo();
		
		//AddressCollection addresses;
	    //PhoneCollection phones;
	    // EmailCollection    emails;
		ContactInfo contactInfo = new ContactInfo();
		buildBaseFields(person, demographicInfo);
		
		AddressInfo[] addresses = buildAddress(person);
		if ( addresses != null)
			contactInfo.setAddresses(new AddressCollection(addresses));

		EmailInfo[] emails = applyEmailData(person);
		if (emails != null && emails.length > 0 )
		{
			contactInfo.setEmails(new EmailCollection(emails));
		}
		
		PhoneInfo[] phones = buildPhones(person.getPhones());
		if ( phones != null && phones.length > 0 )
		{
			contactInfo.setPhones(new PhoneCollection(phones));
		}
		demographicInfo.setContactInfo(contactInfo);
		
		buildBaseFields(person, demographicInfo);
		eeSummary.setDemographics(demographicInfo);
		
		
		buildSensitivityInfo(person, eeSummary);
		
	}
	
	private void buildBaseFields(Person person,DemographicInfo demographicInfo ) {
		/*if (person.getMostRecentPreferredFacility() != null) {
			demographicInfo.setPreferredFacility(person.getMostRecentPreferredFacility()
					.getSiteNumberAndName());
		
		}
		*/
		PreferredFacility pf = (PreferredFacility) this.getPreferredFacilityService().getMostRecentPreferredFacility(person);
   		if(pf != null && pf.getFacility() != null && pf.getFacility().getSiteNumberAndName() != null){
   			demographicInfo.setPreferredFacility(pf.getFacility().getSiteNumberAndName());
   		}
   	
		if (pf != null && pf.getAssignmentDate() != null) {
   			demographicInfo.setAssignmentDate(pf.getAssignmentDate());
   		}
   		
   		if (pf != null && pf.getUnassignmentDate() != null) {
   			demographicInfo.setAssignmentDate(pf.getUnassignmentDate());
   		}
		
		if ( person.getClaimFolderLocation() != null)
			demographicInfo.setClaimFolderLocation(person.getClaimFolderLocation().getSiteNumberAndName());
		
		demographicInfo.setClaimFolderNumber(person.getClaimFolderNumber());
		
		demographicInfo.setAppointmentRequestDate(person.getAppointmentRequestDate());
		demographicInfo.setAppointmentRequestResponse(person.getAppointmentRequestResponse());

		//		CCRxxx added
		PreferredLanguage pl = person.getPreferredLanguage();
		if (pl != null){
			demographicInfo.setPreferredLanguage(pl.getLanguage().getCodeAndDescription());
			demographicInfo.setPreferredLanguageEntryDate(pl.getLanguageEntryDate());
		}


		//PID/10/Z05
		Set races = person.getRaces();

		if (races != null) {
			String[] raceInfos = new String[races.size()];
			Iterator raceIter = races.iterator();
			int i = 0;
			while (raceIter.hasNext()) {
				Race race = (Race) raceIter.next();
				raceInfos[i] = race.getRaceType().getName();
				i++;
			}
			
			if ( raceInfos != null && raceInfos.length > 0 )
			{
				demographicInfo.setRaces(new RaceCollection(raceInfos));
			}
		}

		if (person.getMaritalStatus() != null)
			demographicInfo.setMaritalStatus(person.getMaritalStatus().getName());;

		if (person.getReligion() != null) {
			demographicInfo.setReligion(person.getReligion().getName());
		}

		if (person.getEthnicity() != null
				&& person.getEthnicity().getEthnicityType() != null) {
			demographicInfo.setEthnicity(person.getEthnicity().getEthnicityType()
					.getName());
		}

	}
	
	public String[] buildConfidentialAddressCategories(Person person)
	{
		Set categories = person.getConfidentialAddressCategories();
		if ( categories == null ) return null;
		
		String[] categoryList = new String[categories.size()];
		
		Iterator categoryItr = categories.iterator();
		int i=0;
		while( categoryItr.hasNext())
		{
			ConfidentialAddressCategory category = (ConfidentialAddressCategory) categoryItr.next();
			String val = category.getType() != null?category.getType().getDescription():null;
			categoryList[i] = val;
			i++;
			
		}
		return categoryList;
	}
	/**
	 * Set the direct primitive fields for EESummary
	 * 
	 * @param person
	 * @param summary
	 */
	public  AddressInfo[] buildAddress(Person person) {

		Set addressSet = person.getAddresses();
		
		if ( addressSet == null)  return null;
		
		AddressInfo[] addressInfoArray = new AddressInfo[addressSet.size()];
		Iterator itr = addressSet.iterator() ;
		int i = 0;
		while (itr != null && itr.hasNext()) {
			Address address = (Address) itr.next();
			
			
			AddressInfo addressInfo = buildAddressInfo(address);
			addressInfoArray[i] = addressInfo;
			//ES 4.0.3_CodeCR13163 - Confidential Address Category Types not being returned from EES
			if ( address.getType() != null && AddressType.CODE_CONFIDENTIAL_ADDRESS.getCode().equals(address.getType().getCode()) ) {
				String[] confidentialAddressTypes =	buildConfidentialAddressCategories(person);
				if (confidentialAddressTypes != null ){
					addressInfo.setConfidentialAddressCategories(new ConfidentialAddressCategoryCollection(confidentialAddressTypes));
				}
			}
			//ES 4.0.3_CodeCR13163 - Confidential Address Category Types not being returned from EES
			if((address.getType() != null) && (AddressType.CODE_PERMANENT_ADDRESS.getCode().equals(address.getType().getCode()) || AddressType.CODE_TEMPORARY_CORRESPONDENCE_ADDRESS.getCode().equals(address.getType().getCode()))){
				addressInfo.setContactMethodType(CONTACT_METHOD_TYPE_CODE);
				addressInfo.setContactMethodReportDate(address.getModifiedOn());				
				
			}			
			
			i++;
		}
		return addressInfoArray;
	}

	public  AddressInfo buildAddressInfo(Address address) {
		if (address == null) {
			return null;
		}
		AddressInfo addressInfo = new AddressInfo();		
		addressInfo.setLine1(address.getInternalLine1());
		addressInfo.setLine2(address.getInternalLine2());
		addressInfo.setLine3(address.getInternalLine3());
		addressInfo.setPostalCode(address.getPostalCode());
		addressInfo.setZipCode(address.getZipCode());
		addressInfo.setZipPlus4(address.getZipPlus4());
		addressInfo.setCity(address.getCity());
		addressInfo.setState(address.getState());
		addressInfo.setProvinceCode(address.getProvince());
		addressInfo.setCounty(address.getCounty());
		addressInfo.setCountry(address.getCountry());
		addressInfo.setAddressChangeDateTime(address.getChangeDate());
		addressInfo
				.setAddressChangeEffectiveDate(address.getStartDate() != null ? address
						.getStartDate().getStandardFormat()
						: null);
		
		addressInfo.setEndDate(address.getEndDate() != null ? address
				.getEndDate().getStandardFormat()
				: null);

		
		if (address.getChangeSite() != null) {
			addressInfo.setAddressChangeSite(address.getChangeSite()
					.getSiteNumberAndName() != null ? address.getChangeSite()
					.getSiteNumberAndName() : null);
		}
		
		if ( address.getChangeSource() != null)
		{
			addressInfo
				.setAddressChangeSource(address.getChangeSource().getDescription() != null ? address
						.getChangeSource().getDescription()
						: null);
		}
		
		if ( address.getType() != null)
		{
			addressInfo
				.setAddressTypeCode(address.getType().getCode() != null ? address
						.getType().getName()
						: null);
		}
//      16 fields
        if (address.getBadAddressReason() != null)
        {
            addressInfo.setBadAddressReason(address.getBadAddressReason().getName());
        }
      
		addressInfo.setPhoneNumber(address.getPhoneNumber());

		return addressInfo;
	}

	private  EmailInfo[] applyEmailData(Person person) {
		Set emails = person.getEmails();

		if (emails == null)
			return null;

		EmailInfo[] emailInfos = new EmailInfo[emails.size()];
		Iterator emailIter = emails.iterator();
		int i = 0;
		while (emailIter.hasNext()) {
			Email email = (Email) emailIter.next();
			EmailInfo emailInfo = new EmailInfo();

			if (email.getType() != null)
				emailInfo.setType(email.getType().getDescription());

			emailInfo.setAddress(email.getAddress());

			if (email.getSiteOfChange() != null)
				emailInfo.setSiteOfChange(email.getSiteOfChange()
						.getSiteNumberAndName());
             //	EE Services_CodeCR10413|EE Service: Email Change Source returned as Code
			if (email.getSourceOfChange() != null)
				emailInfo
						.setSourceOfChange(email.getSourceOfChange().getDescription());
			emailInfos[i] = emailInfo;
			i++;
		}
		return emailInfos;
	}
	
	
	/**
	 * Set the direct primitive fields for EESummary
	 * 
	 * @param person
	 * @param summary
	 */
	public  AssociationInfo[] buildContacts(Person person) {
		Association contact;
		Set associationSet = person.getAllAssociations();
		AssociationInfo[] eeAssociationInfo = new AssociationInfo[associationSet
				.size()];

		Iterator itr = associationSet != null ? associationSet.iterator()
				: null;
		int i = 0;
		while (itr != null && itr.hasNext()) {
			AssociationInfo associationInfo = new AssociationInfo();
			contact = (Association) itr.next();
			//ZCTBuilder sement 2 to 10.
			if ( contact.getType() != null)
			{
				associationInfo
					.setContactType(contact.getType() != null ? contact
							.getType().getDescription()
							: null);
			}
			//    			sequence 3. CONTACT NAME      LAST~FIRST  MIDDLE~SUFFIX~~~~NAME TYPE
			Name name = contact.getRepresentativeName();
			if (name != null) {
				associationInfo
						.setFamilyName(name.getFamilyName() != null ? name
								.getFamilyName() : null);
				associationInfo.setGivenName(name.getGivenName() != null ? name
						.getGivenName() : null);
				associationInfo
						.setMiddleName(name.getMiddleName() != null ? name
								.getMiddleName() : null);
				associationInfo.setSuffix(name.getSuffix());
				associationInfo.setPrefix(name.getPrefix());
			}
			
			associationInfo
					.setRelationship(contact.getRelationship() != null ? contact
							.getRelationship()
							: null);
			Address contactAddress = contact.getAddress();
			if (contactAddress != null) {
				BaseAddressInfo baseAddressInfo = new BaseAddressInfo();
				baseAddressInfo.setLine1(contactAddress.getInternalLine1());
				baseAddressInfo.setLine2(contactAddress.getInternalLine2());
				baseAddressInfo.setLine3(contactAddress.getInternalLine3());
				baseAddressInfo.setPostalCode(contactAddress.getPostalCode());
				baseAddressInfo.setZipCode(contactAddress.getZipCode());
				baseAddressInfo.setZipPlus4(contactAddress.getZipPlus4());
				baseAddressInfo.setCity(contactAddress.getCity());
				baseAddressInfo.setState(contactAddress.getState());
				associationInfo.setAddress(baseAddressInfo);
			}
			associationInfo.setOrganizationName(contact.getOrganizationName());
			
			associationInfo.setPrimaryPhone(contact.getPrimaryPhone());
			associationInfo.setAlternatePhone(contact.getAlternatePhone());
		    associationInfo.setLastUpdateDate(contact.getLastUpdateDate());
			eeAssociationInfo[i] = associationInfo;
			i++;
		}
		return eeAssociationInfo;
	}




	/**
	 * Other than spouse and dependednts
	 * @param person
	 * @return
	 */
	public  RelationInfo[] buildRelations(Person person) {
		Relation relation;
		Set relationSet = person.getRelations();
		
		if ( relationSet == null )
		{
			return null;
		}
		
		ArrayList relList = new ArrayList();
		Iterator itr =  relationSet.iterator() ;
		int i = 0;
		while (itr != null && itr.hasNext()) {
			relation = (Relation) itr.next();

			RelationInfo relationInfo =populateRelationInfo(relation, new RelationInfo());
			
			relList.add(relationInfo);
			i++;
		}// end for dependent while.
		return (RelationInfo[])relList.toArray(new RelationInfo[relList.size()]);
	}

	/**
	 * Other than spouse and dependednts
	 * @param person
	 * @return
	 */
	public  RelationInfo populateRelationInfo(Relation relation, RelationInfo relationInfo) {
		if (relation == null) {
			return null;
		}

		Name name = relation.getName();
		if (name != null) {
			relationInfo.setFamilyName(name.getFamilyName());
			relationInfo.setGivenName(name.getGivenName());
			relationInfo.setMiddleName(name.getMiddleName());
			relationInfo.setPrefix(name.getPrefix());
			relationInfo.setSuffix(name.getSuffix());
			
			// dependentInfo.setSuffix(name.getSuffix());
		}
		relationInfo.setDob(relation.getDob() != null ? relation.getDob()
				.getStandardFormat() : null);
		relationInfo.setGender(relation.getGender() != null ? relation
				.getGender().getName() : null);
		relationInfo.setStartDate(relation.getStartDate()!=null ? relation.getStartDate().getStandardFormat():null);
		relationInfo.setEndDate(relation.getEndDate());
		relationInfo
				.setRelationship(relation.getRelationship() != null ? relation
						.getRelationship().getDescription() : null);

		Set ssnSet = relation.getSsns();
		if (ssnSet != null && ssnSet.size() > 0) {
			SSNInfo[] eeDependSSNInfo = new SSNInfo[ssnSet.size()];
			Iterator ssnItr = ssnSet != null ? ssnSet.iterator() : null;
			int count = 0;
			while (ssnItr != null && ssnItr.hasNext()) {
				SSN ssn = (SSN) ssnItr.next();
				SSNInfo ssnInfo = new SSNInfo();
				ssnInfo.setSsnText(ssn.getFormattedSsnText());				
				ssnInfo.setSourceOfChange(ssn.getSourceOfChange() != null ? ssn
						.getSourceOfChange().getCode() : null);
				ssnInfo.setSsaMessage(
						ssn.getSsaMessage() != null?ssn.getSsaMessage().getDescription():null);
				ssnInfo
						.setPseudoSSNReason(ssn.getPseudoSSNReason() != null ? ssn
								.getPseudoSSNReason().getDescription()
								: null);
				ssnInfo.setSsaReceivedDate(ssn.getSsaReceivedDate());
				ssnInfo.setSsaSentDate(ssn.getSsaSentDate());
				ssnInfo.setSsaVerificationDate(ssn.getSsaVerificationDate());
				ssnInfo
						.setSsaVerificationStatus(ssn
								.getSsaVerificationStatus() != null ? ssn
								.getSsaVerificationStatus().getDescription()
								: null);
				ssnInfo.setType(ssn.getType() != null ? ssn.getType().getName()
						: null);				
				eeDependSSNInfo[count] = ssnInfo;
				count++;
			}// end for ssn while

			if (eeDependSSNInfo != null && eeDependSSNInfo.length > 0) {
				relationInfo.setSsns(new SSNCollection(eeDependSSNInfo));
			}
		}// end for ssn if
		relationInfo.setEndDate(relation.getEndDate());
		return relationInfo;
	}
	
	
	public  InsuranceInfo[] buildInsurance(Person person) {
		// Insurance insurance ;
		Set insuranceSet = person.getInsurances();
		
		if ( insuranceSet == null) return null;
		
		InsuranceInfo[] eeInsuranceInfo = new InsuranceInfo[insuranceSet.size()];
		Iterator itr =  insuranceSet.iterator();
		int count = 0;
		while (itr != null && itr.hasNext()) {
			InsurancePolicy insurance = (InsurancePolicy) itr.next();
			InsuranceInfo insuranceInfo = new InsuranceInfo();
			insuranceInfo.setCompanyName(insurance.getCompanyName());
			insuranceInfo.setGroupNumber(insurance.getGroupNumber());
			insuranceInfo.setGroupName(insurance.getGroupName());
			insuranceInfo.setPolicyHolderName(insurance.getSubscriber()!= null ? insurance.getSubscriber()
					.getName():null);
			insuranceInfo
					.setInsuredRelationship(insurance.getSubscriber() != null ? (insurance
							.getSubscriber().getRelationship() != null ? insurance
							.getSubscriber().getRelationship().getDescription()
							: null)
							: null);
			Address insAddress = insurance.getAddress();
			
			AddressInfo insAddressInfo = buildAddressInfo(insAddress);
			if(insAddressInfo != null){
				insAddressInfo.setContactMethodType(CONTACT_METHOD_TYPE_CODE);
				insAddressInfo.setContactMethodReportDate(insAddress.getModifiedOn());				
			}			
			
			insuranceInfo.setInsAddress(insAddressInfo);
			
			Set insurancePhones = new HashSet();
			Phone insBusPhone = insurance.getBusinessPhone();
			Phone insFax = insurance.getFax();
			Phone insPreCerftPhone = insurance.getPreCertificationPhone();
			
			if  ( insBusPhone != null ) {
				insurancePhones.add(insBusPhone);
			}
			if ( insFax != null ) {
				insurancePhones.add(insFax);
			}
			if ( insPreCerftPhone != null ) {
				insurancePhones.add(insPreCerftPhone);
			}
			
			if ( insurancePhones.size() > 0 ) {
				insuranceInfo.setInsurancePhones(new PhoneCollection(buildPhones(insurancePhones)));
			}
			if (insurance instanceof PrivateInsurance) {
				
				if (( (PrivateInsurance) insurance).getPolicyEffectiveDate() != null)
				{
					String policyEffectiveDate = ((PrivateInsurance) insurance)
							.getPolicyEffectiveDate().getStandardFormat();
					insuranceInfo.setPolicyEffectiveDate(policyEffectiveDate);
				}
				
				if (( (PrivateInsurance) insurance).getPolicyExpirationDate() != null)
				{
					String policyExpirationDate = ((PrivateInsurance) insurance)
						.getPolicyExpirationDate().getStandardFormat();
					insuranceInfo.setPolicyExpirationDate(policyExpirationDate);
				}
				

				insuranceInfo.setPolicyNumber(((PrivateInsurance) insurance)
						.getPolicyNumber());
			} else if (insurance instanceof Medicare) {

				Medicare medicare = (Medicare) insurance;
				String groupName = medicare.getGroupName();
				String groupNumber = medicare.getGroupNumber();
				if ((groupName != null && groupName
						.equalsIgnoreCase(IN1.MEDICARE_PART_A))
						|| (groupNumber != null && groupNumber
								.equalsIgnoreCase(IN1.MEDICARE_PART_A))) {
				   // insuranceInfo.setPartAEffectiveDate(medicare.getPartAEffectiveDate());
	
					String partAEffectiveDate = null;
					if (medicare!=null && medicare.getPartAEffectiveDate()!=null){
						 partAEffectiveDate = medicare.getPartAEffectiveDate().getStandardFormat();	 
					}
					insuranceInfo.setPartAEffectiveDate(partAEffectiveDate);
					insuranceInfo.setEnrolledInPartA(medicare.getEnrolledInPartA());
					
				} else if ((groupName != null && groupName
						.equalsIgnoreCase(IN1.MEDICARE_PART_B))
						|| (groupNumber != null && groupNumber
								.equalsIgnoreCase(IN1.MEDICARE_PART_B))) {
					// insuranceInfo.setPartBEffectiveDate(medicare.getPartBEffectiveDate());
					
					String partBEffectiveDate = null;
					if (medicare!=null && medicare.getPartBEffectiveDate()!=null){
						partBEffectiveDate = medicare.getPartBEffectiveDate().getStandardFormat();
					}
					insuranceInfo.setPartBEffectiveDate(partBEffectiveDate);
					insuranceInfo.setEnrolledInPartB(medicare
							.getEnrolledInPartB());
				}
				insuranceInfo
						.setPolicyNumber(medicare.getMedicareClaimNumber());

			}
			insuranceInfo
					.setPlanType(insurance.getInsurancePlan() != null ? (insurance
							.getInsurancePlan().getPlanType() != null ? insurance
							.getInsurancePlan().getPlanType().getDescription()
							: null)
							: null);
			//insuranceInfo.setInsuranceMappingType()--Check
            insuranceInfo
            .setInsuranceMappingTypeName(insurance.getInsurancePlan() != null ? (insurance
                    .getInsurancePlan().getPlanType() != null ? insurance
                    .getInsurancePlan().getPlanType().getName()
                    : null)
                    : null);
            
			if ( insurance.getInsuranceSiteUploadStatus() != null)
			{
				insuranceInfo
					.setInsuranceSiteUploadStatus(insurance
							.getInsuranceSiteUploadStatus() != null ? insurance
							.getInsuranceSiteUploadStatus().getDescription()
							: null);
			}
			insuranceInfo.setLastEditedDate(insurance.getModifiedOn());
			
			insuranceInfo.setReasonInsuranceNotUploaded(insurance
					.getReasonInsuranceNotUploaded() != null ? insurance
					.getReasonInsuranceNotUploaded().getDescription() : null);

	
			if ( insurance.getInsurancePlan() != null)
			insuranceInfo.setPreadmitCertification(insurance.getInsurancePlan().getPrecertificationRequired());
			
			eeInsuranceInfo[count] = insuranceInfo;
			count++;
		}
		return eeInsuranceInfo;

	}

	public  EmploymentInfo buildEmployment(Person person) {
		Employment employment = person.getEmployment();
		
		return buildEmployment(employment); 
	}
	
	
	public  EmploymentInfo buildEmployment(Employment employment) {

		if (employment == null ) return null;
		
		EmploymentInfo employmentInfo = new EmploymentInfo();

		if (employment != null) {
			employmentInfo.setEmployerName(employment.getEmployerName());
			employmentInfo.setEmployerPhone(employment.getEmployerPhone());
			employmentInfo.setOccupation(employment.getOccupation());
			employmentInfo
					.setEmploymentStatus(employment.getEmploymentStatus() != null ? employment
							.getEmploymentStatus().getDescription()
							: null);
            if(employment.getRetirementDate() != null){
                
			employmentInfo.setRetirementDate(employment.getRetirementDate().toString());
            }
            //Added for webservice due to imprecise date. previously it was date.
         //   employmentInfo.setRetirementDateString(employment.getRetirementDate().toString());
			Address empAddress = employment.getEmployerAddress();
			employmentInfo.setEmployerAddress(buildAddressInfo(empAddress));
			

		}
		return employmentInfo;
	}

	
	private void  buildSensitivityInfo(Person person, EESummary summary) {
		
		SensitivityInfo sensitivityInfo = new SensitivityInfo();
		sensitivityInfo.setSensitivityChangeDate(person.getSensitivityChangeDate());

		sensitivityInfo.setSensityFlag(person.getSensitiveRecord());
		
		if (person.getSensitivityChangeSite() != null)
			sensitivityInfo.setSensitivityChangeSite(person.getSensitivityChangeSite()
					.getSiteNumberAndName());

		if (person.getSensitivityChangeSource() != null)
			sensitivityInfo.setSensitivityChangeSource(person
					.getSensitivityChangeSource().getDescription());
		
		summary.setSensitivityInfo(sensitivityInfo);
	}
	
	
	private  PhoneInfo[] buildPhones(Set phones)
	{
		if ( phones == null ) return null;
		
		PhoneInfo[] phoneInfos = new PhoneInfo[phones.size()];
		
		Iterator phoneItr = phones.iterator();
		int i=0;
		while ( phoneItr.hasNext())
		{
			Phone phone = (Phone)phoneItr.next();
			
			PhoneInfo pInfo = new PhoneInfo();
			pInfo.setPhoneNumber(phone.getPhoneNumber());
			pInfo.setPhoneNumberReportDate(phone.getModifiedOn());
			
			if ( phone.getType() != null)
			{
				pInfo.setType(phone.getType().getDescription());
			}
			phoneInfos[i] = pInfo;
			i++;
		}
		return phoneInfos;
	}

	public PreferredFacilityService getPreferredFacilityService() {
		return preferredFacilityService;
	}

	public void setPreferredFacilityService(
			PreferredFacilityService preferredFacilityService) {
		this.preferredFacilityService = preferredFacilityService;
	}
}
