package gov.va.med.esr.service.external;

import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.service.external.person.AddressInfo;
import gov.va.med.esr.service.external.person.AssociationInfo;
import gov.va.med.esr.service.external.person.EESummary;
import gov.va.med.esr.service.external.person.EmploymentInfo;
import gov.va.med.esr.service.external.person.InsuranceInfo;
import gov.va.med.esr.service.external.person.RelationInfo;

public interface DemographicSummaryFactory {

	public void applyDemographicsInfo(Person person, EESummary eeSummary);

	/**
	 * Set the direct primitive fields for EESummary
	 * 
	 * @param person
	 * @param summary
	 */
	public AddressInfo[] buildAddress(Person person);

	  public String[] buildConfidentialAddressCategories(Person person); 
	  public AddressInfo buildAddressInfo(Address address); 
	  
	/**
	 * Set the direct primitive fields for EESummary
	 * 
	 * @param person
	 * @param summary
	 */
	public AssociationInfo[] buildContacts(Person person);

	/**
	 * Other than spouse and dependednts
	 * 
	 * @param person
	 * @return
	 */
	public RelationInfo[] buildRelations(Person person);

	/**
	 * Other than spouse and dependednts
	 * 
	 * @param person
	 * @return
	 */
	public RelationInfo populateRelationInfo(Relation relation,
			RelationInfo relationInfo);

	public InsuranceInfo[] buildInsurance(Person person);

	public EmploymentInfo buildEmployment(Employment employment);

	public EmploymentInfo buildEmployment(Person person);

	// public PhoneInfo[] buildPhones(Person person);
}
