/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.util.StringUtils;

import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.lookup.WkfCaseStatusType;
import gov.va.med.esr.common.model.lookup.WkfCaseType;
import gov.va.med.esr.common.model.lookup.WkfIssueType;

public class WorkflowSearchCriteria extends SearchQueryInfo implements
		Serializable {

	private static final long serialVersionUID = 1608807920232179066L;

	private FunctionalGroup functionalGroup;

	private WkfCaseType itemType;

	private WkfCaseStatusType itemStatus;

	private WkfIssueType issueType;

	private String assignedTo;

	private Date createDateFrom;

	private Date createDateTo;

	private Date assignedDateFrom;

	private Date assignedDateTo;

	private String ssn;

	private String familyName;

	private String givenName;

	private String personId;

	private boolean assignedItems;

	private boolean unassignedItems;

	private boolean openItems;

	private boolean overdueItems;

	private Date assignedDate;

	private Date createDate;

	private String itemNumber;

	private List vpids;
	
	private List personIds;

	public Date getAssignedDateFrom() {
		return assignedDateFrom;
	}

	public Date getAssignedDateTo() {
		return assignedDateTo;
	}

	public String getAssignedTo() {
		return assignedTo;
	}

	public Date getCreateDateFrom() {
		return createDateFrom;
	}

	public Date getCreateDateTo() {
		return createDateTo;
	}

	public String getFamilyName() {
		return familyName;
	}

	public FunctionalGroup getFunctionalGroup() {
		return functionalGroup;
	}

	public String getGivenName() {
		return givenName;
	}

	public WkfCaseStatusType getItemStatus() {
		return itemStatus;
	}

	public WkfCaseType getItemType() {
		return itemType;
	}

	public String getSsn() {
		return ssn;
	}

	public void setAssignedDateFrom(Date assignedDateFrom) {
		this.assignedDateFrom = assignedDateFrom;
	}

	public void setAssignedDateTo(Date assignedDateTo) {
		this.assignedDateTo = assignedDateTo;
	}

	public void setAssignedTo(String assignedTo) {
		this.assignedTo = assignedTo;
	}

	public void setCreateDateFrom(Date createDateFrom) {
		this.createDateFrom = createDateFrom;
	}

	public void setCreateDateTo(Date createDateTo) {
		this.createDateTo = createDateTo;
	}

	public void setFamilyName(String familyName) {
		this.familyName = familyName;
	}

	public void setFunctionalGroup(FunctionalGroup functionalGroup) {
		this.functionalGroup = functionalGroup;
	}

	public void setGivenName(String givenName) {
		this.givenName = givenName;
	}

	public void setItemStatus(WkfCaseStatusType itemStatus) {
		this.itemStatus = itemStatus;
	}

	public void setItemType(WkfCaseType itemType) {
		this.itemType = itemType;
	}

	public void setSsn(String ssn) {
		this.ssn = ssn;
	}

	public List getVpids() {
		return vpids;
	}

	public void setVpids(List vpids) {
		this.vpids = vpids;
	}

	public List getPersonIds() {
		return personIds;
	}

	public void setPersonIds(List personIds) {
		this.personIds = personIds;
	}

	public boolean isAssignedItems() {
		return assignedItems;
	}

	public boolean isUnassignedItems() {
		return unassignedItems;
	}

	public void setAssignedItems(boolean assignedItems) {
		this.assignedItems = assignedItems;
	}

	public void setUnassignedItems(boolean unassignedItems) {
		this.unassignedItems = unassignedItems;
	}

	public boolean isOpenItems() {
		return openItems;
	}

	public String getPersonId() {
		return personId;
	}

	public void setOpenItems(boolean openItems) {
		this.openItems = openItems;
	}

	public void setPersonId(String personId) {
		this.personId = personId;
	}

	public WkfIssueType getIssueType() {
		return issueType;
	}

	public void setIssueType(WkfIssueType issueType) {
		this.issueType = issueType;
	}

	public boolean isOverdueItems() {
		return overdueItems;
	}

	public void setOverdueItems(boolean overdueItems) {
		this.overdueItems = overdueItems;
	}

	public Date getAssignedDate() {
		return this.assignedDate;
	}

	public void setAssignedDate(Date assignedDate) {
		this.assignedDate = assignedDate;
	}

	public Date getCreateDate() {
		return this.createDate;
	}

	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	public String getItemNumber() {
		return this.itemNumber;
	}

	public void setItemNumber(String itemNumber) {
		this.itemNumber = itemNumber;
	}

	public boolean isIdentityTraitsSpecified() {
		return StringUtils.isNotEmpty(ssn) || StringUtils.isNotEmpty(familyName)
				|| StringUtils.isNotEmpty(givenName);
	}
}
