/********************************************************************
 * Copyright  2004-2005 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service;

// Java Classes

// Framework classes
import gov.va.med.esr.common.model.comms.GeocodeTransmit;
import gov.va.med.esr.common.model.comms.VCDeterminationHistoryForm;
import gov.va.med.esr.common.model.comms.Waittime;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.service.ServiceException;

import java.io.Serializable;
import java.util.List;

/**
 * Service to process Veterans Choice Information
 * @author DNS   RAOS
 *
 */
public interface VeteransChoiceInformationService extends Serializable {

	/**
	 * get the most current Geocode Transmit record processed by PSSG transaction
	 * @param incoming person
	 * @return most recent Geocode Transmit record for Veteran
	 * @throws ServiceException
	 */
	public GeocodeTransmit fetchGeocodeTransmitRecord(Person person) throws ServiceException;

	/**
	 * get the most current Waittime record processed by CDW transaction
	 * @param incoming person
	 * @return most recent Waittime record for Veteran
	 * @throws ServiceException
	 */
	public Waittime fetchWaittimeRecord(Person person) throws ServiceException;
 
	/**
	 * get all Waittime records processed by CDW transaction
	 * @param incoming person
	 * @return all Waittime records for Veteran
	 * @throws ServiceException
	 */
	public List fetchAllWaittimeRecords(Person person) throws ServiceException;
	
	public List fetchVCChangeTimeLog(Person person) throws ServiceException;
	
	public VCDeterminationHistoryForm fetchVCDeterminationHistory(String input) throws ServiceException;
}