package gov.va.med.esr.service;

import gov.va.med.esr.common.model.ee.VoaFileAttachment;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.VOAApplication;
import gov.va.med.esr.common.persistent.person.VOAApplicationDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.service.ServiceException;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

import gov.va.med.fw.service.pagination.PaginatedSearchService;
import gov.va.med.fw.service.pagination.SearchQueryInfo;

/**
 * The Service for VOA Application.
 * Project: Common
 *
 * @author DNS   TSAIG
 * @version 3.11
 */
public interface VOAApplicationService extends Serializable, PaginatedSearchService

{

	/**
	 * Save a VOAApplication
	 * @param app
	 * @return VOAApplication saved
	 * @throws ServiceException
	 */
	public VOAApplication save(VOAApplication app) throws ServiceException;

	/**
     * Gets the VOA attachment by person ID
     *
     * @param personId
     * @return The list of VOA attachments, null when empty
     * @throws DAOException
     *         Thrown when a persistence exception occurs.
     */
    @SuppressWarnings("rawtypes")
	public List findVoaAttachmentByPersonId(BigDecimal personId) throws ServiceException;

    public void setVOAFormFailed(VOAApplication app, Person incoming)
			throws ServiceException;

    public VOAApplicationDAO getVoaApplicationDAO() ;
	/**
     * Gets the VOA attachment by VOA application ID
     *
     * @param applicationId
     * @return The list of VOA attachments, null when empty
     * @throws DAOException
     *         Thrown when a persistence exception occurs.
     */
    @SuppressWarnings("rawtypes")
	public List findVoaAttachmentByApplicationId(BigDecimal applicationId) throws ServiceException;

    public VOAApplication findMostRecentApplicationByPersonId(BigDecimal personId)  throws ServiceException;

    public VOAApplication findMostRecentApplicationBySSN(String ssn)  throws ServiceException;

    public List findByFQID(String fqid) throws ServiceException;

	/**
     * Update the VOA attachment attributes
     *
     * @param attachment
     * @throws DAOException
     *         Thrown when a persistence exception occurs.
     */
    public void updateAttachmentAttributes(VoaFileAttachment attachment)  throws ServiceException;

    /**
     * Update the Person Id of the VOA attachment with the specified message control id
     * @param msgControlId
     * @param personId
     * @throws ServiceException
     */
    public void updateVoaAttachmentWithPersonId(String msgControlId, BigDecimal personId)  throws ServiceException;

    /**
     * forward VOA application to common JMS queue
     * @param applicationId VOA application id
     * @param person person object
     * @throws ServiceException
     * NOTE: applicationId and person must not be null
     */

    public void forwardVOAApplication(BigDecimal applicationId, Person person) throws ServiceException;

	/**
     * Gets the VOA Application by VOA application ID
     *
     * @param applicationId
     * @return VOAApplication
     * @throws DAOException
     *         Thrown when a persistence exception occurs.
     */
    public VOAApplication findVoaApplicationByApplicationId(BigDecimal applicationId) throws ServiceException;

    /**
     * Update VOAApplication
     * @param app
     * @return updated VOAApplication
     * @throws ServiceException
     */
    public VOAApplication updateVOAApplication(VOAApplication app) throws ServiceException;

    /**
     * Process VOA Application with application id and person object
     * @param applicationId
     * @param person
     * @return Person result person
     * @throws ServiceException
     */
    public Person processVoaApplication(BigDecimal applicationId, Person incoming) throws ServiceException;

    @SuppressWarnings("rawtypes")
	public List searchPendingSubmissions(SearchQueryInfo searchCriteria) throws ServiceException;

    /**
     * Get a list of VOAApplications that are available for resubmission
     * @return List of VOAApplications
     * @throws ServiceException
     */
    @SuppressWarnings("rawtypes")
	public List getResubmissionVOAApplications() throws ServiceException;

    @SuppressWarnings("rawtypes")
	public void resubmit(List applicationsIds) throws ServiceException;

    /**
     * Resubmit a VOAApplication
     * @param app
     * @throws ServiceException
     */
    public void resubmitVoaApplication(VOAApplication voaApp) throws ServiceException;


    /**
	 * RTC Task 236652 -Fix for when a veteran answers no to the disclose financial details option the VOA form.
	 * This method was changed to public to facilitate the implementation for the task item.
	 */
    public boolean isDSLogonLevel2(VOAApplication app);

}