/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service;

import gov.va.med.esr.common.model.lookup.FunctionalGroup;
import gov.va.med.esr.common.model.security.CapabilitySet;
import gov.va.med.esr.common.model.security.ESRUserPrincipalImpl;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.security.RolePrincipal;
import gov.va.med.fw.security.SecurityService;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.ServiceException;

import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.security.auth.login.LoginException;

public interface UserAdminService extends SecurityService{

    //User Administration methids
    public ESRUserPrincipalImpl getUserByName(String userName) throws ServiceException;

    public ESRUserPrincipalImpl updateUserAccount(ESRUserPrincipalImpl user) throws ServiceException;

    public ESRUserPrincipalImpl addUserAccount(ESRUserPrincipalImpl user) throws ServiceException;

    public ESRUserPrincipalImpl updateUserProfile(ESRUserPrincipalImpl user) throws ServiceException;

    public boolean isValidNetworkId(String userName) throws ServiceException;

    public boolean isSecurityCodeValid(ESRUserPrincipalImpl user, String securityCode);

    public boolean isSecurityCodeRequired(ESRUserPrincipalImpl user);

    public ESRUserPrincipalImpl getLDAPUserInfo(String userName) throws ServiceException;

    //User profile Administration Methods
    public List getAllRoles() throws ServiceException;

    public List getAllCapabilitySets() throws ServiceException;

    public List getAllCapabilities() throws ServiceException;

    public void addCapabilitySet(CapabilitySet capabilitySet) throws ServiceException;

    public void updateCapabilitySet(CapabilitySet capabilitySet) throws ServiceException;

    public void deleteCapabilitySet(CapabilitySet capabilitySet) throws ServiceException;

    public void addRole(RolePrincipal role) throws ServiceException;

    public void updateRole(RolePrincipal role) throws ServiceException;

    public void deleteRole(RolePrincipal role) throws ServiceException;

    public ESRUserPrincipalImpl findUser(UserPrincipal user) throws ServiceException;

    public ESRUserPrincipalImpl findUserByName(String userName) throws ServiceException;

    public CapabilitySet getCapabilitySetById(EntityKey entityKey) throws ServiceException;

    public CapabilitySet getCapabilitySetByName(String name) throws ServiceException;

    public RolePrincipal getRoleById(EntityKey entityKey) throws ServiceException;

    public RolePrincipal getRoleByName(String name) throws ServiceException;

    public Set getHistoryChangeTimes(EntityKey personID)
        throws ServiceException ;

    public HistoricalInfo getHistoryByChangeTime(ChangeEvent event)
        throws ServiceException ;

    public String encryptPassword(String clearText) throws ServiceException;

    public List findDeletedRoles() throws ServiceException;

    public List findDeletedCapabilitySets() throws ServiceException;

    public List findAllUsers() throws ServiceException;

    public List findUsersByRoleName(String roleName) throws ServiceException;

    public List findUsersByCapabilityCode(String capabilityCode) throws ServiceException;

    public List findUsersByFunctionalGroup(FunctionalGroup functionalGroup) throws ServiceException;

    public List findUsersByRoleAndFunctionalGroup(FunctionalGroup functionalGroup, String roleName) throws ServiceException;

    public Lookup getByCode(String userName) throws ServiceException;

    public Lookup getByFullname(String userName) throws ServiceException;
    //CCR13343 SSOi integration
    public String getSsoEnabled() throws ServiceException;
    public String getSsoUsername() throws ServiceException;
    public boolean isSsoEnforced() throws ServiceException;
    public String getSsoLogoffUrl() throws ServiceException;
    public String getSsoErrorUrl() throws ServiceException;
    public Map getRolePermissionMap() throws ServiceException;
    public Map getCapabilityPermissionMap() throws ServiceException;
    public void validatePasswordReuse(ESRUserPrincipalImpl userPrincipal, String newPassword) throws LoginException;
}
