/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service;

//Java classes

//Library classes

//Framework classes
import gov.va.med.fw.service.ServiceException;

//EDB Classes

/**
 * This exception is thrown to indicate that an unknown dao is specified
 * to query lookup code from a data source.  All lookup daos need to be 
 * configured in the LookupServiceImpl prior to any call to query lookup
 * data using a LookupServiceImpl class.
 * 
 * @author Martin Francisco, Vu Le
 */
public class UnknownLookupTypeException extends ServiceException {

	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -4660713636708097201L;
	private Class dao = null;
	
	/**
	 * Creates a <code>UnknownLookupTypeException</code> with the specified
	 * message, and data access object class used to query lookup data
	 * 
	 * @param msg The exception message.
	 * @param type The data access object class
	 */
	public UnknownLookupTypeException( String msg, Class type ) {
		super(msg);
		this.dao = type;
	}
	
	/** Append a data access class to the end of an exception message
	 * @see java.lang.Throwable#getMessage()
	 */
	public String getMessage() {
		StringBuffer msg = new StringBuffer( super.getMessage() );
		msg.append( " DAO: " )
		   .append( (dao != null) ? dao.getName() : null );
		
		return msg.toString();
	}
	
	/**
	 * Returns a data access class to query lookup data
	 * @return Returns a dao class to query lookup data
	 */
	public Class getType() {
		return dao;
	}
}