/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service;

//Java classes

//Library classes

//Framework classes
import gov.va.med.fw.service.ServiceException;

//EDB Classes

/**
 * This exception is thrown to indicate that an unknown lookup code
 * is used to query a lookup code. An exception message is appended
 * with the specific lookup code and data access object used to query
 * lookup data.
 * 
 * @author Martin Francisco, Vu Le
 */
public class UnknownLookupCodeException extends ServiceException {
	
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 1320716266505147123L;
	private String code = null;
	private Class dao = null;
	
	/**
	 * Creates a <code>UnknownLookupCodeException</code> with the specified
	 * message, a lookup code, and a dao to access the data source
	 * 
	 * @param msg The exception message.
	 * @param code The code to look up.
	 */
	public UnknownLookupCodeException(String msg, String code, Class dao ) {
		super(msg);
		this.code = code;
		this.dao = dao;
	}
	
	/** Append a look up code to the end of an exception message
	 * @see java.lang.Throwable#getMessage()
	 */
	public String getMessage() {
		StringBuffer msg = new StringBuffer( super.getMessage() );
		msg.append( " Code: " )
		   .append( code )
		   .append( " DAO: " )
		   .append( (dao != null) ? dao.getName() : null );
		
		return msg.toString();
	}
	
	/**
	 * Returns a code to look up 
	 * @return Returns the code.
	 */
	public String getCode() {
		return code;
	}
	
	/**
	 * Returns a code to look up 
	 * @return Returns the code.
	 */
	public Class getType() {
		return dao;
	}
}