/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service;

import java.util.Date;
import java.util.List;
import java.util.Set;

import gov.va.med.fw.service.ServiceException;
import gov.va.med.esr.common.model.system.SystemParameter;

public interface SystemParameterService {
    public List findAll() throws ServiceException;

    public SystemParameter getByName(String parameterName) throws ServiceException;

    public Set save(Set parameters) throws ServiceException;

    public String getEsrVersion() throws ServiceException;
    public Date getEsrImplementationDate() throws ServiceException;
    public Date getEnrollmentRegulationDate() throws ServiceException;
    // CCR 11781 use VFA Start Date for figuring if expiration applies to income test
    public Date getVFAStartDate() throws ServiceException;

    /*
     *  Agent Orange Special Treatment Authority Indicator
     */
    public Boolean getAOTreatmentAuthorityIndicator() throws ServiceException;

    /*
     * SW Asia Conditions Special Treatment Authority Indicator
     */
    public Boolean getECTreamentAuthorityIndicator() throws ServiceException;

    /*
     *  Agent Orange Special Treatment Authority Expiration Date
     */
    public Date getAOTreatmentAuthorityExpirationDate() throws ServiceException;

    /*
     * SW Asia Conditions Special Treatment Authority Expiration Date
     */
    public Date getECTreatmentAuthorityExpirationDate() throws ServiceException;

    public Boolean getVOAAnonymousLevel1ProcessIndicator() throws ServiceException;

    public Boolean getMSDSServiceIndicator() throws ServiceException;

    public Boolean getMSDSReconIndicator() throws ServiceException;


    public String getHandBookReleaseCtl() throws ServiceException;

    public boolean isHandBookRollOutOver() throws ServiceException;

    public Boolean getVBADataSharingIndicator() throws ServiceException;

    public Boolean getHBPDataSharingIndicator() throws ServiceException; //CCR12064

    public void updateDefaultHandBookReleaseCtl(String releaseCtl) throws ServiceException;

    public Boolean getIVMFinalLetterIndicator() throws ServiceException;

    public Boolean getEsSidIndicator() throws ServiceException;

    public Boolean getDODIndicator() throws ServiceException;

    //CCR 13856
    public Boolean getDODSharing() throws ServiceException;

    public String getCLVistARolloutStr() throws ServiceException;
}
