/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service;

//Java classes
import java.io.Serializable;

//Library classes

//Framework classes

//EDB Classes

/**
 * @author Martin Francisco
 */
public class SearchCriteria
    implements Serializable
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 3411544872484033370L;

	private String ssn;

    private String givenName;

    private String middleName;

    private String familyName;

    private boolean caseSensitive;

    /**
     * The specific search criteria
     */
    public SearchCriteria(
        String ssn,
        String givenName,
        String middleName,
        String familyName)
    {
        this(ssn, givenName, middleName, familyName, true);
    }

    public SearchCriteria(
        String ssn,
        String givenName,
        String middleName,
        String familyName,
        boolean caseSensitive)
    {
        super();

        this.ssn = ssn;
        this.givenName = givenName;
        this.middleName = middleName;
        this.familyName = familyName;
        this.caseSensitive = caseSensitive;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.service.SearchCriteria#getGivenName()
     */
    public String getGivenName()
    {
        return givenName;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.service.SearchCriteria#getMiddleName()
     */
    public String getMiddleName()
    {
        return middleName;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.service.SearchCriteria#getFamilyName()
     */
    public String getFamilyName()
    {
        return familyName;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.service.SearchCriteria#getSsn()
     */
    public String getSsn()
    {
        return ssn;
    }

    /*
     * (non-Javadoc)
     * 
     * @see gov.va.med.esr.service.SearchCriteria#isCaseSensitive()
     */
    public boolean isCaseSensitive()
    {
        return caseSensitive;
    }
}