package gov.va.med.esr.service;

// Java classes
import java.io.Serializable;

import gov.va.med.esr.common.clock.Clock;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.service.trigger.ClockTriggerEvent;
import gov.va.med.fw.service.ServiceException;

/**
 * Provides services related to scheduled tasks. 
 * 
 * @author Carlos Ruiz
 * @version 3.0
 */
public interface ScheduledTaskService extends Serializable {


    /**
     * Start a specific clock for a person.
     * 
     * @param person
     * @param hours
     * @param type
     * @param group
     * @param jobDetail
     * @throws ServiceException
     */
    public void startClock( Person person, double hours, Clock.Type type, Clock.Group group, String jobDetailBeanName) throws ServiceException;
    
    /**
     * Start a specific clock for a person that deals with letter for veteran or spouse or dependent 
     * 
     * @param person
     * @param hours
     * @param type
     * @param group
     * @param jobDetail
     * @param subject
     * @throws ServiceException
     */
    public void startClock( Person person, double hours, Clock.Type type, Clock.Group group, String jobDetailBeanName, String subject ) throws ServiceException;    
    public void startClock( PersonEntityKey personId, double hours, Clock.Type type, Clock.Group group, String jobDetailBeanName, String subject ) throws ServiceException;
    
    public void startClock(ClockTriggerEvent triggerEvent) throws ServiceException;
    
    /**
     * Cancel a specific clock for a person.
     * 
     * @param person
     * @param type
     * @param group
     * @throws ServiceException
     */
    public void cancelClock(Person person, Clock.Type type, Clock.Group group) throws ServiceException;
    
    /**
     * Cancel clock for specific subject
     * 
     * @param person
     * @param type
     * @param group
     * @param subject
     * @throws ServiceException
     */
    public void cancelClock(Person person, Clock.Type type, Clock.Group group, String subject ) throws ServiceException;    
    
    public void cancelClock(ClockTriggerEvent triggerEvent) throws ServiceException;
    
    // Start of Convenience methods
    
    /**
     * Start the VOA 72 hours pending clock.
     * 
     * @param person
     * @throws ServiceException
     */
    public void startVOAPendingClock(Person person) throws ServiceException;
    
    
    public void startMilServiceQueryClock(Person person) throws ServiceException;    

    /**
     * Start the PH pending clock.
     * 
     * @param person
     * @throws ServiceException
     */
    public void startPHPendingClock(Person person) throws ServiceException;
    
    /**
     * Start the PH Unacceptable Letter clock.
     * 
     * @param person
     * @throws ServiceException
     */
    public void startPHLetterClock(Person person) throws ServiceException;    
    
    /**
     * 
     * @param person
     * @throws ServiceException
     */
    public void startZ11PendingTraitsClock(Person person) throws ServiceException;    

    /**
     * Start the SSN invalid letter clock.
     * 
     * @param person
     * @param subject
     * @throws ServiceException
     */
    public void startSSNInvalidLetterClock(Person person, String subject) throws ServiceException;
    

    /**
     * 
     * @param person
     * @param subject 
     * @throws ServiceException
     */
    public void startPseudoSSNReasonClock(Person person, String subject) throws ServiceException;      
    
    /**
     * 
     * @param person
     * @param subject 
     * @throws ServiceException
     */
    public void cancelPseudoSSNReasonClock(Person person, String subject) throws ServiceException;      
    
    /**
     * 
     * @param person
     * @param subject 
     * @throws ServiceException
     */
    public void startPseudoSSNVerificationClock(Person person, String subject) throws ServiceException;    
  

}
