/*******************************************************************************
 * Copyright  2006 VHA. All rights reserved
 ******************************************************************************/

/*
 * Created on Feb 23, 2006
 */
package gov.va.med.esr.service;



import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractLookup;

// EDB Classes

/**
 * @author Venky Kullampalle
 * @version 1.0
 */
public class ReportStatus extends AbstractLookup {
	/**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = -8324961336832941892L;

	public static final Code ACTIVE = new Code("1");
	public static final Code INACTIVE = new Code("2");
    
    public static final String ACTIVE_DESCRIPTION="Active";
    public static final String INACTIVE_DESCRIPTION="Archived";
  
	
	public static class Code extends AbstractCode {
		/**
		 * An instance of serialVersionUID
		 */
		private static final long serialVersionUID = 2871895184008159232L;

		private Code(String code) {
			super(code);
		}

		public static Code getByCode(String code) {
			return (Code) getCode(Code.class, code);
		}
	}    
	
    public ReportStatus() {
        super();
    }
}
