// Package 
package gov.va.med.esr.service;

// Java Classes
import java.io.Serializable;
import java.util.Date;

// Library Classes
import org.apache.commons.lang.builder.ToStringBuilder;

// Framework Classes
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.security.UserPrincipal;

// ESR Classes
import gov.va.med.esr.common.model.lookup.ReportType;
import gov.va.med.esr.common.model.lookup.StandardReport;

/**
 * This class extends the default SearchQueryInfo by adding the search parameters needed to perform a
 * report filtering.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class ReportFilterSearchQueryInfo extends SearchQueryInfo implements Serializable
{
    private static final long serialVersionUID = 3965263461783639160L;
    private ReportType reportType = null;
    private StandardReport standardReport = null;
    private ReportExportedType reportExportedType = null;
    private Date dateFrom = null;
    private Date dateTo = null;
    private UserPrincipal user = null;

    public ReportType getReportType()
    {
        return reportType;
    }

    public void setReportType(ReportType reportType)
    {
        this.reportType = reportType;
    }

    public StandardReport getStandardReport()
    {
        return standardReport;
    }

    public void setStandardReport(StandardReport standardReport)
    {
        this.standardReport = standardReport;
    }

    public ReportExportedType getReportExportedType()
    {
        return reportExportedType;
    }

    public void setReportExportedType(ReportExportedType reportExportedType)
    {
        this.reportExportedType = reportExportedType;
    }

    public UserPrincipal getUser()
    {
        return user;
    }

    public void setUser(UserPrincipal user)
    {
        this.user = user;
    }

    public Date getDateFrom()
    {
        return dateFrom;
    }

    public void setDateFrom(Date dateFrom)
    {
        this.dateFrom = dateFrom;
    }

    public Date getDateTo()
    {
        return dateTo;
    }

    public void setDateTo(Date dateTo)
    {
        this.dateTo = dateTo;
    }

    /**
     * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder);

        builder.append("reportType", getReportType());
        builder.append("standardReport", getStandardReport());
        builder.append("reportExportedType", getReportExportedType());
        builder.append("dateFrom", getDateFrom());
        builder.append("dateTo", getDateTo());
        builder.append("user", getUser());
    }
}
