/*******************************************************************************
 * Copyright  2010 VHA. All rights reserved
 ******************************************************************************/
package gov.va.med.esr.service;

import gov.va.med.esr.common.model.financials.RelaxationPercentage;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.batchprocess.BatchProcessDetail;
import gov.va.med.fw.service.ServiceException;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

/**
 * Class that provides services related to the relaxation percentage used in
 * financial calculations.
 * 
 * @author DNS   barryc
 */
public interface RelaxationPercentageService extends Serializable {

	/**
	 * Find the relaxation percentage defined in the database for the specified
	 * four-digit income year.
	 * 
	 * @param incomeYear
	 *            The four-digit income year
	 * @return See description
	 * @throws ServiceException
	 */
	RelaxationPercentage getRelaxationPercentageByIncomeYear(int incomeYear)
			throws ServiceException;

	/**
	 * Update the detached specified relaxation percentage defined in the
	 * database.
	 * 
	 * @param incomeYear
	 *            The incomeYear of the RelaxationPercentage we want to update
	 * @param value
	 *            The new value for the applicable RelaxationPercentage
	 * @param retroactiveProcess
	 *            Whether to initiate the retroactive process after updating the
	 *            specified RelaxationPercentage.
	 * @throws ServiceException
	 */
	void updateRelaxationPercentage(int incomeYear, BigDecimal value,
			boolean retroactiveProcess ,BatchProcessDetail batchProcessDetail) throws ServiceException;

	/**
	 * Add a new relaxation percentage to the database for the next income year
	 * (which is the current calendar year)
	 * 
	 * @param bigDecimal
	 *            The value to add
	 */
	void addRelaxationPercentage(BigDecimal bigDecimal) throws ServiceException;

	/**
	 * @return All RelaxationPercentages defined in the system
	 */
	List getAllRelaxationPercentages();

	Set getRelaxationPercentageHistoryChangeTimes() throws ServiceException;

	HistoricalInfo getRelaxationPercentageHistoryByChangeTime(ChangeEvent event)
			throws ServiceException;

}