  
/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service;

// Java Classes
import java.util.List;
import java.util.Set;

// Framework Classes
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.registry.RegistryLoadStatistics;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.pagination.PaginatedSearchService;
import gov.va.med.fw.service.pagination.SearchQueryInfo;

/**
 * Registry service interface.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public interface RegistryService extends PaginatedSearchService {
    
    /**
     * Gets the registry object matching registry id and registry type.
     * 
     * @param entityKey the EntityKey
     * @param registryType the registry type
     * @return
     * @throws ServiceException
     */
    public Registry getRegistryById(EntityKey entityKey,RegistryType registryType) throws ServiceException;
   
    /**
     * Searches the registry database for matching registry records.
     * 
     * @param searchCriteria the registry criteria object
     */
    public List search(SearchQueryInfo searchCriteria) throws ServiceException;
    
    /**
     * Processes the registry and saves it to the database.
     * @param registry the registry object to be updated
     * @throws ServiceException
     */
    public void updateRegistry(Registry registry) throws ServiceException;
    
    
    /**
     * @param key
     * @return Set<ChangeEvent> 
     * @throws ServiceException
     */
    public Set getHistoryChangeTimes( EntityKey key ) throws ServiceException;
    
    /**
     * @param event
     * @return
     * @throws ServiceException
     */
    public HistoricalInfo getHistoryByChangeTime(ChangeEvent event) throws ServiceException;

    /**
     * Process registry from batch process.
     * 
     * @param registry
     * @return
     * @throws ServiceException
     */
    public LoadRegistryResult processRegistry(Registry registry) throws ServiceException;
    

    /**
     * Gets the latest entry in the Laod Registry Summary table for the given RegistryType
     * 
     * @param registryType
     * @return
     * @throws ServiceException
     */
    public RegistryLoadStatistics getMostRecentRegistrySummaryByType(RegistryType registryType) throws ServiceException;    
    
    /**
     * This method links person with registry.
     * @param incoming
     * @param onfile
     * @param incomingPerson
     * @param onFilePerson
     * @param registryType
     * @param isFromUI
     * @throws ServiceException
     */
    public void linkPersonRegistry(Registry incoming, Registry onFile, Person incomingPerson, Person onFilePerson,RegistryType registryType, boolean isFromUI)  throws ServiceException;
    
    /**
     * This method links all three registries.
     * @param incoming
     * @param onFile
     * @throws ServiceException
     */
    public void linkPersonRegistries(Person incoming, Person onFile, boolean isFromUI)throws ServiceException;
    
    /**
     * This method returns exact matching RegistryTrait if it is found.
     * 
     * @param registrySearchCriteria
     * @return
     * @throws ServiceException
     */
    public Registry getMatchingRegistry(RegistrySearchCriteria registrySearchCriteria) throws ServiceException;
    
    public RegistrySearchCriteria  getRegistrySearchCriteria(Person person, String registryType) throws ServiceException;    
  }
