/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service;

import java.io.Serializable;
import java.math.BigDecimal;

import gov.va.med.fw.model.EntityKey;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.DecorationStatus;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.RegistryType;

/**
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class RegistrySearchResultBean implements Serializable {

    private static final long serialVersionUID = -4510585544417595809L;
    
    private BigDecimal registryId;
    private BigDecimal personId;
    private String ssn;
    private String firstName;
    private String middleName;
    private String lastName;
    private RegistryType registryType;
    private DecorationStatus phStatus;
    private Indicator indicator;
    
    public RegistrySearchResultBean() {}
    
    public RegistrySearchResultBean(BigDecimal registryId,String ssn, String firstName, String middleName, String lastName, RegistryType registryType,BigDecimal personId,DecorationStatus phStatus) {
        this.registryId = registryId;
        this.ssn = ssn;
        this.firstName = firstName;
        this.middleName = middleName;
        this.lastName = lastName;
        this.registryType = registryType;
        this.personId = personId;
        this.phStatus = phStatus;
    }
    
    public RegistrySearchResultBean(BigDecimal registryId,String ssn, String firstName, String middleName, String lastName, RegistryType registryType,BigDecimal personId,Indicator indicator) {
        this.registryId = registryId;
        this.ssn = ssn;
        this.firstName = firstName;
        this.middleName = middleName;
        this.lastName = lastName;
        this.registryType = registryType;
        this.personId = personId;
        this.indicator = indicator;
    }
    
    public EntityKey getEntityKey() {
    	EntityKey key = null;
    	if(registryType != null && registryId != null) {
	    	String code = registryType.getCode();
	    	if(RegistryType.CODE_PH_REGISTRY.getCode().equals(code))
	    		key = CommonEntityKeyFactory.createPurpleHeartEntityKey(registryId.toString());
	    	else if(RegistryType.CODE_POW_REGISTRY.getCode().equals(code))
	    		key = CommonEntityKeyFactory.createPrisonerOfWarEntityKey(registryId.toString());
	    	else if(RegistryType.CODE_SHAD_REGISTRY.getCode().equals(code))
	    		key = CommonEntityKeyFactory.createSHADEntityKey(registryId.toString());	    	
    	}    	
    	return key;
    }
    
    public BigDecimal getRegistryId() {
        return registryId;
    }

    public void setRegistryId(BigDecimal registryId) {
        this.registryId = registryId;
    }

    public BigDecimal getPersonId() {
        return this.personId;
    }
    
    public void setPersonId(BigDecimal personId) {
        this.personId = personId;
    }
    
    public String getEligibilityRecordFound() {
        return (this.personId != null) ? "Yes" : "No";
    }
    
    public String getSsn() {
        return this.ssn;
    }
    
    public void setSsn(String ssn) {
        this.ssn = ssn;
    }
    
    public String getFirstName() {
        return firstName;
    }
    
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }
    
    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }
    
    public String getLastName() {
        return lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }
    
    public RegistryType getRegistryType() {
        return registryType;
    }

    public void setRegistryType(RegistryType registryType) {
        this.registryType = registryType;
    }

    public DecorationStatus getPhStatus() {
        return phStatus;
    }

    public void setPhStatus(DecorationStatus phStatus) {
        this.phStatus = phStatus;
    }

    public Indicator getPowIndicator() {
        return indicator;
    }

    public void setPowIndicator(Indicator powIndicator) {
        this.indicator = powIndicator;
    }

    public Indicator getShadIndicator() {
        return indicator;
    }

    public void setShadIndicator(Indicator shadIndicator) {
        this.indicator = shadIndicator;
    }
}
