/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service;

// Java classes

// Library classes

// Framework classes
import java.util.Set;

import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.service.ServiceException;

// EDB classes
import gov.va.med.esr.common.clock.Clock;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;

/**
 * Project: Common
 * @author Muddaiah Ranga
 * @version 1.0
 */
public interface PurpleHeartService extends HistoricalInfoService {

   /**
    * 1. Merge purple heart with the person in file
    * 2. Calculate EE
    * 3. Trigger a message to the site that the veteran has visited
    * 4. Saves the person to the dabase
    * 
    * @param incoming An incoming person containing purple heart info
    * @return An updated person with purple heart information
    * @throws ServiceException Thrown if failed to update 
    */
   public Person updatePurpleHeart( Person incoming ) throws ServiceException;
   
   /**
    * Executes the manage PH use case rules for a clock batch process.
    * 
    * @param incoming
    * @param clockType
    * @return
    * @throws ServiceException
    */
   public Person updatePurpleHeart( Person incoming, Clock.Type clockType ) throws ServiceException;   
   
   /**
    * Get the history change time for a person's purple heart
    * 
    * @param personID
    * @return
    * @throws ServiceException
    */
   public Set getPurpleHeartHistoryChangeTimes( EntityKey personID ) throws ServiceException;

   /**
    * Get history info for a particular time.
    * 
    * @param event
    * @return
    */
   public HistoricalInfo getPurpleHeartHistoryByChangeTime( ChangeEvent event ) throws ServiceException;    
}