/********************************************************************
 * Copyright  2004-2005 EDS. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service;

// Java Classes

// Framework classes
import gov.va.med.esr.common.batchprocess.PCMMImportData;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.PreferredFacility;
import gov.va.med.esr.common.model.person.PreferredFacilityPerson;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.fw.service.ServiceException;

import java.util.List;
import java.util.Set;

/**
 */
public interface PreferredFacilityService {
  	
	/**
	 * Find a light weight person by DFN and Station Number 
	 */
	public PreferredFacilityPerson findPreferredFacilityPerson(String dfn, String stationNumber) throws ServiceException;
	
   /**
    * Persist a lightweight person into a database
    * @param person A person to persist
    * @retrun Updated Person
    * @throws ServiceException Thrown if failed to persist a person
    */
   public PreferredFacilityPerson savePreferredFacilityPerson(PreferredFacilityPerson person) throws ServiceException;
   
   public void processPCMMData(PCMMImportData data) throws ServiceException;
   
   public void triggerZ11(PersonEntityKey key, PersonIdentityTraits traits) throws ServiceException;
   
   public boolean hasActivePreferredFacility(Set pfList) throws ServiceException;
   
   public Set getActivePreferredFacilities(Set pfList) throws ServiceException;

   /**
    * Uses regular (heavy weight) person object, suitable for Z07, Z11, and UI processes
    * @param person
    * @return
    */
   public PreferredFacility getMostRecentPreferredFacility(Person person);
   
   /**
    * Uses regular (heavy weight) person object, suitable for Z07, Z11, and UI processes
    * @param person
    * @return
    */
   public boolean hasPCPActiveOrESRPF(Person person);

   /**
    * Uses regular (heavy weight) person object, suitable for Z07, Z11, and UI processes
    * @param person
    * @return
    */
   public boolean hasPCPActivePF(Person person);
   
   /**
    * Uses regular (heavy weight) person object, suitable for VOA
    * CCR12879_AJ_VOA - Apply PF processing logic when VOA submitted PF
    * @param person
    * @return
    */
   public boolean hasVistaOrPCPInactivePF(Person person);
   
   /**
    * Uses regular (heavy weight) person object, suitable for Z07, Z11, and UI processes
    * @param person
    * @return
    */
   public PreferredFacility getPreferredFacilityFromVista(Person person);

   /**
    * Uses regular (heavy weight) person object, suitable for VOA
    * CCR12879_AJ_VOA - Apply PF processing logic when VOA submitted PF
    * @param person
    * @return
    */
   public PreferredFacility getPreferredFacilityFromES(Person person);
      
   
   /**
    * Returns list of preferred facilities to be displayed by the UI
    * @return
    */
   public List getDisplayPreferredFacilities(Person person);

	/**
	 * Add a new preferred facility from VistA or ESR. Trigger Z11.
	 * Note: For Messaging/UI, uses heavy weight objects.  Not for use with initial seeding batch job.
	 * 
	 * @param incoming  Incoming preferred facility object
	 * @param onfilePerson onfilePerson to be updated
	 * @param sdCode sourceDesignation -- either "VistA" (update from messaging) or "ESR" (update from UI)
	 * @throws ServiceException
	 */
   public void addPreferredFacility(PreferredFacility incoming, Person onfilePerson, String sdCode) throws ServiceException;

	/**
	 * update the calculated most recent prefered facility result onto person object
	 * @param person
	 */
   public void setCalculatedMostRecentPreferredFacility(Person person);
   
   /**
	 * Get list of Child VaFacility 
	 * 
	 * @return VaFacility A corresponding Child VaFacilities
	 */
	public  List getChildVAFacility(List parentIds)
	throws UnknownLookupTypeException, UnknownLookupCodeException;

	/**
	 * Returns set of active preferred facility sites for person, if no acdtive PFs are found, return the most recent inactive PF
	 * @param person
	 * @return
	 * @throws ServiceException
	 */
	public Set<VAFacility> getPreferredFacilitySites(Person person) throws ServiceException;
	
	/**
	 * Returns set of active preferred facility sites for person, if no acdtive PFs are found, return the most recent inactive PF
	 * @param person
	 * @return
	 * @throws ServiceException
	 */
	public Set<VAFacility> getPFSites(Person person) throws ServiceException;
}