package gov.va.med.esr.service;

// Java classes
import java.util.List;

import gov.va.med.esr.common.model.person.PersonUnmergeInfo;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.pagination.PaginatedSearchService;
import gov.va.med.fw.service.pagination.SearchQueryInfo;

/**
 * @author DNS   CHENB
 *
 * Provides services related to the unmerging of a Veteran.
 */
public interface PersonUnmergeService extends PaginatedSearchService
{
    /**
     * get PersonUnmergeInfo for given key
     * @param personUnmergeInfoEntityKey
     * @return
     * @throws ServiceException
     */
    public PersonUnmergeInfo getPersonUnmergeInfo(EntityKey personUnmergeInfoEntityKey) throws ServiceException;

    /**
     * delete after review it by user
     * @param info
     * @throws ServiceException
     */
    public void deletePersonUnmergeInfo(PersonUnmergeInfo info) throws ServiceException;

	/* Process and store PeronUnmerge request from external
	 * if there is a record in Person_Merge with matching pair of pesonIds
	 * then delete it and not insert anything to Person_Unmerge
	 * if there is a record in Person_Unmerge for both PersonIds
	 * then do nothing
	 * 
	 * <p>Note that this may or may not necessarily mean an undo of a "merge"</p>
	 * @param info
	 */
    public void processPersonUnmergeInfo(PersonUnmergeInfo info) throws ServiceException;
    
    /**
     * Searches and returns a list of PersonUnmergeInfo objects.
     *
     * @param searchQueryInfo The search criteria
     *
     * @return The list of PersonUnmergeInfo objects
     * @throws ServiceException if any problems were encountered.
     */
    public List search(SearchQueryInfo searchQueryInfo) throws ServiceException;
}
