/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service;

// Java Classes
import java.io.Serializable;

// Third Party Classes
import org.apache.commons.lang.builder.ToStringBuilder;

// Framework Classes
import gov.va.med.esr.common.model.lookup.SelfIdentifiedGenderIdentity;
import gov.va.med.fw.service.pagination.SearchQueryInfo;

/**
 * This class extends the default SearchQueryInfo by adding the search parameters needed to perform a person search.
 *
 * @author Andrew Pach
 * @version 3.0
 */
public class PersonSearchQueryInfo extends SearchQueryInfo implements Serializable
{
    /**
	 * An instance of serialVersionUID
	 */
	private static final long serialVersionUID = 3529847293605878714L;
	private String ssn = null;
    private String givenName = null;
    private String middleName = null;
    private String familyName = null;
    private String dateOfBirth = null;
    private String gender = null;
    private SelfIdentifiedGenderIdentity sigi = null;
    private String claimFolderNumber = null;
    private String militaryServiceNumber = null;
    private String vpid = null;

    // CCR 10471 ADD A PERSON
    private boolean addAPerson = false;
    private String preferredFacility = null;
    private String multipleBirth = null;
    //private String mothersMaidenName = null;
    //private String placeOfBirthCity = null;
    //private String placeOfBirthState = null;
    private String address = null;
    private String city = null;
    private String state = null;
    private String zipCode = null;
    private String postalCode = null;
    private String country = null;
    //private String province = null;
    private String homePhoneNumber = null;

    public String getUnformattedSsn()
    {
        return ssn;
    }

    public void setUnformattedSsn(String value)
    {
        ssn = value;
    }

    public String getFamilyName()
    {
        return familyName;
    }

    public void setFamilyName(String value)
    {
        familyName = value;
    }

    public String getMiddleName()
    {
        return middleName;
    }

    public void setMiddleName(String value)
    {
        middleName = value;
    }

    public String getGivenName()
    {
        return givenName;
    }

    public void setGivenName(String value)
    {
        givenName = value;
    }

	public String getDateOfBirth() {
		return dateOfBirth;
	}
	public void setDateOfBirth(String dateOfBirth) {
		this.dateOfBirth = dateOfBirth;
	}
	public String getGender() {
		return gender;
	}
	public void setGender(String gender) {
		this.gender = gender;
	}
	public SelfIdentifiedGenderIdentity getSigi() {
		return sigi;
	}

	public void setSigi(SelfIdentifiedGenderIdentity sigi) {
		this.sigi = sigi;
	}

	public String getMilitaryServiceNumber() {
		return militaryServiceNumber;
	}
	public void setMilitaryServiceNumber(String militaryServiceNumber) {
		this.militaryServiceNumber = militaryServiceNumber;
	}
	public String getClaimFolderNumber() {
		return claimFolderNumber;
	}
	public void setClaimFolderNumber(String claimFolderNumber) {
		this.claimFolderNumber = claimFolderNumber;
	}

    public String getVpid() {
		return this.vpid;
	}

	public void setVpid(String vpid) {
		this.vpid = vpid;
	}

	/**
     * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
     */
    protected void buildToString(ToStringBuilder builder)
    {
        super.buildToString(builder);

        builder.append("unformattedSsn", getUnformattedSsn());
        builder.append("familyName", getFamilyName());
        builder.append("middleName", getMiddleName());
        builder.append("givenName", getGivenName());
        builder.append("dateOfBirth",getDateOfBirth());
        builder.append("gender",getGender());
        builder.append("claimFolderNumber",getClaimFolderNumber());
        builder.append("militaryServiceNumber",getMilitaryServiceNumber());
        builder.append("vpid",getVpid());

        // CR10471 ADD A PERSON
        builder.append("address",getAddress());
        builder.append("city",getCity());
        builder.append("state",getState());
        builder.append("zipCode",getZipCode());
        builder.append("postalCode",getPostalCode());
        builder.append("country",getCountry());
        builder.append("homePhoneNumber",getHomePhoneNumber());
    }

	public String getPreferredFacility() {
		return preferredFacility;
	}

	public void setPreferredFacility(String preferredFacility) {
		this.preferredFacility = preferredFacility;
	}

	public boolean isAddAPerson() {
		return addAPerson;
	}

	public void setAddAPerson(boolean addAPerson) {
		this.addAPerson = addAPerson;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getCountry() {
		return country;
	}

	public void setCountry(String country) {
		this.country = country;
	}

	public String getHomePhoneNumber() {
		return homePhoneNumber;
	}

	public void setHomePhoneNumber(String homePhoneNumber) {
		this.homePhoneNumber = homePhoneNumber;
	}

	public String getPostalCode() {
		return postalCode;
	}

	public void setPostalCode(String postalCode) {
		this.postalCode = postalCode;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getZipCode() {
		return zipCode;
	}

	public void setZipCode(String zipCode) {
		this.zipCode = zipCode;
	}
}