/********************************************************************
 * Copyright  2009 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service;

// Java Classes
import gov.va.med.fw.service.pagination.SearchQueryInfo;

import java.io.Serializable;

import org.apache.commons.lang.builder.ToStringBuilder;

public class PersonMergeWorklistSearchQueryInfo extends SearchQueryInfo implements
		Serializable {

	private static final long serialVersionUID = 1L;
	private String ssn = null;
	private String givenName = null;
	private String middleName = null;
	private String familyName = null;
	private String dateOfBirth = null;
	private String gender = null;
	private String claimFolderNumber = null;
	private String militaryServiceNumber = null;
	private String vpid = null;

	public String getUnformattedSsn() {
		return ssn;
	}

	public void setUnformattedSsn(String value) {
		ssn = value;
	}

	public String getFamilyName() {
		return familyName;
	}

	public void setFamilyName(String value) {
		familyName = value;
	}

	public String getMiddleName() {
		return middleName;
	}

	public void setMiddleName(String value) {
		middleName = value;
	}

	public String getGivenName() {
		return givenName;
	}

	public void setGivenName(String value) {
		givenName = value;
	}

	public String getDateOfBirth() {
		return dateOfBirth;
	}

	public void setDateOfBirth(String dateOfBirth) {
		this.dateOfBirth = dateOfBirth;
	}

	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	public String getMilitaryServiceNumber() {
		return militaryServiceNumber;
	}

	public void setMilitaryServiceNumber(String militaryServiceNumber) {
		this.militaryServiceNumber = militaryServiceNumber;
	}

	public String getClaimFolderNumber() {
		return claimFolderNumber;
	}

	public void setClaimFolderNumber(String claimFolderNumber) {
		this.claimFolderNumber = claimFolderNumber;
	}

	public String getVpid() {
		return this.vpid;
	}

	public void setVpid(String vpid) {
		this.vpid = vpid;
	}

	/**
	 * @see gov.va.med.fw.model.AbstractEntity#buildToString(org.apache.commons.lang.builder.ToStringBuilder)
	 */
	protected void buildToString(ToStringBuilder builder) {
		super.buildToString(builder);

		builder.append("unformattedSsn", getUnformattedSsn());
		builder.append("familyName", getFamilyName());
		builder.append("middleName", getMiddleName());
		builder.append("givenName", getGivenName());
		builder.append("dateOfBirth", getDateOfBirth());
		builder.append("gender", getGender());
		builder.append("claimFolderNumber", getClaimFolderNumber());
		builder.append("militaryServiceNumber", getMilitaryServiceNumber());
		builder.append("vpid", getVpid());
	}
}