/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/

package gov.va.med.esr.service;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.fw.service.ServiceException;


/**
 * Delegate service for VHA Person Service requests.
 * 
 * <p>
 * Most apis deal with the primary view of identity traits, which is the version
 * of identity traits that the enterprise sees as the latest and greatest.
 * 
 * <p>
 * A few apis deal with "submitted" identity traits, which is the latest version
 * of identity traits that ESR has submitted (could be different than the
 * primary view's version).
 * 
 * Created Aug 23, 2005 9:33:19 PM
 * 
 * @author DNS   BOHMEG
 */
public interface PSDelegateService extends Serializable {
	
	public static final String ID_STATE_PERMANENT = "P";
	public static final String ID_STATE_TEMPORARY = "T";
	
	/**
	 * Added this method for CR_7382, used to check if the User is a System or HealthCare user.
	 * @param key
	 * @return boolean
 	 * @throws Exception
	 */
	//Search in the ESR project shows that this method is not used anymore 
   // public boolean isSystemOrHealthCareUser(VPIDEntityKey key)throws ServiceException;
    
    /** Retrieve VPID from DFN and StationNumber */
	public VPIDEntityKey getVPID(String dfn, String stationNumber)
			throws ServiceException;

	/** Retrieve IdentityTraits from DFN and StationNumber */
	//Use the getIdentityTrraitsforCompositeCall
	//public PersonIdentityTraits getIdentityTraits(String dfn, String stationNumber) throws ServiceException;

	/**
	 * Retrieve IdentityTraits based on VPID (from primary view as the
	 * enterprise sees it)
	 */
	public PersonIdentityTraits getIdentityTraits(VPIDEntityKey key)
			throws ServiceException;

	/**
	 * Retrieve IdentityTraits based on VPID (from ESR correlation as ESR has
	 * submitted it to PSIM)
	 */
	public PersonIdentityTraits getSubmittedIdentityTraits(VPIDEntityKey key)
			throws ServiceException;

	/**
	 * Retrieve IdentityTraits based on VPID
	 * 
	 * @param vpidEntityKeys
	 *            A Collection of VPIDEntityKey objects
	 * @return Map keyed by VPIDEntityKey and value of PersonIdentityTraits
	 */
	public Map getIdentityTraits(Collection vpidEntityKeys)
			throws ServiceException;

	/**
	 * Retrieves the "submitted" (i.e. correlation) IdentityTraits based on a
	 * collection of VPIDs.
	 * 
	 * @param vpidEntityKeys
	 *            the collection of VPIDs.
	 * @return the map of VPID's to their submitted traits.
	 */
	public Map getSubmittedIdentityTraits(Collection vpidEntityKeys)
			throws ServiceException;

	/**
	 * Retrieve sites that the Person with passed-in VPID is known to
	 * 
	 * @param key
	 * @return Set<SiteIdentity>
	 */
	 public Set getSites(VPIDEntityKey key) throws ServiceException;
	
	/**
	 * General purpose search using identity traits from an attended process
	 * (eg, UI)
	 * 
	 * @param criteria
	 * @return Set<PersonIdentityTrait>
	 */
	 //CR 11776 - attended search can only be non-composite
	 public Set attendedSearch(PersonIdentityTraits traits, boolean enforceESRSecurity) throws ServiceException;
	 

	/**
	 * General purpose search using identity traits from an unattended process
	 * (eg, Messaging)
	 * 
	 * @param criteria
	 * @return Set<PersonIdentityTrait>
	 */
	public Set unattendedSearch(PersonIdentityTraits criteria) throws ServiceException;


	
	/**
	 * Notify PSD that the demographic information on the Person has changed
	 * 
	 * @param key
	 *            The VPID of the person whose information has changed
	 */
	   //both methods below not used by ESR anymore
	/*public void notifyPsdOfDemographicChange(VPIDEntityKey key)
			throws ServiceException;*/

	/** Request an update to a Person's identity traits */
	/*public void requestIdentityTraitsUpdate(PersonIdentityTraits updatedTraits)
			throws ServiceException;*/

	/** Gets history of updates to identity traits */
	public List getIdentityTraitsUpdateHistory(VPIDEntityKey key)
			throws ServiceException;

	public List getSubmittedIdentityTraitsUpdateHistory(VPIDEntityKey key)
			throws ServiceException;

	/** Extracts (does not remove) the salient identity traits from a Person */
	public PersonIdentityTraits extractIdentityTraits(Person person);

	/**
	 * Retrieves VPIDs for Persons whose SSA Verification status matches one of
	 * those passed in.
	 * 
	 * @param SSAVerificationStatuses -
	 *            Set of SSAVerificationStatus codes (eg, the String "VERIFIED")
	 * @return Set<VPIDEntityKey>
	 * @throws ServiceException
	 */
	//this method is not used by ESR anymore
	/*public Set getVPIDsBySSAVerificationStatuses(Set SSAVerificationStatuses)
			throws ServiceException;*/
    
    /**
     * Determines if the facility is supported in the current running environment
     * 
     * @param VAFacility 
     * @return boolean indicating if the facility is supported
     * @throws ServiceException
     */
    public boolean isSupportedInEnvironment(VAFacility facility) throws ServiceException;
    
    
    /**
     * get the IDState
     * 
     * @param VPIDEntity key
     * @return String IDState
     * @throws ServiceException
     */
    public String getIDState(VPIDEntityKey key) throws ServiceException;
    
    
    /**
     * request the IDState change
     * 
     * @param VPIDEntity key
     * @param EnrollmentStatus status
     * @return String IDState
     * @throws ServiceException
     */
    public String requestIDStateChange(VPIDEntityKey key, EnrollmentStatus status) throws ServiceException;
    
    /**
     * add preferred "proxy" treating facility
     * 
     * @param Person person
     * @param String IDState to be changed to
     * @return PersonIdentityTraits personTraits
     * @throws ServiceException
     */
    //based on searching the projects workspace, ESR does not use this method anymore 
   // public void addPreferredTreatingFacility(Person person) throws ServiceException;

    
    /**
     * get identity traits with dnf, station number with composite call
     * @param dfn
     * @param stationNumber
     * @return
     * @throws ServiceException
     */
    
    public PersonIdentityTraits getIdentityTraitsWithCompositeCall(String dfn, String stationNumber) throws ServiceException;
    
    /**
     * get identity traits with vpid with composite call
     * @param key
     * @return
     * @throws ServiceException
     */
    public PersonIdentityTraits getIdentityTraitsWithCompositeCall(VPIDEntityKey key) throws ServiceException;
    
    /**
	 * Retrieve sites that the Person with passed-in VPID is known to
	 * 
	 * @param key
	 * @return String
	 */
	 public String getVhicId(VPIDEntityKey key) throws ServiceException;

}
