package gov.va.med.esr.service;

import java.io.Serializable;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.MedalOfHonor;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;


/**
 * Response information from Msds used by Process MSDS data rules.
 * 
 * @author DNS   ruizc
 *
 */
public class MsdsResponseInfo implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -7337665359250721053L;
	
	public static final String VADIR_BIRLS_UNREACHABLE = "01";
	public static final String PERSON_NOT_FOUND = "02";
	public static final String MULTIPLE_PERSON_FOUND = "03";
	public static final String SUCCESS_DATA_ONE_SOURCE = "04";
	public static final String INVALID_CHARACTER_OF_SERVICE_VADIR = "05";	
	public static final String INVALID_CHARACTER_OF_SERVICE_BIRLS = "06";
	public static final String CHARACTER_OF_SERVICE_NOT_SAME_IN_BOTH = "07";
	
	private Person vadirPerson = null;
	private PersonEntityKey personEntityKey;
	private Person birlsPerson = null;
	private Person esrPerson = null;	
	private MilitaryService vadirMilitaryService = null;
	private MilitaryService birlsMilitaryService = null;
	private boolean hasDisabilityRetirement = false;	
	private boolean satisfiesUpgradeCriteria = false;
	private boolean processQMSEflow = true;
	private boolean hasQmse = false;	
	private String msdsReceivedStatus = null;
	private String vadirError = null;	
	private String birlsError = null;	
	private String oefoifInd = null;
	private String msdsWorkItem = null;	
	// These are just shells used to convey the PH & MH indicators in 
	// a form that can be accessed by rules.  ESR will create a proper
	// object per business rules.
	private PurpleHeart purpleHeart = new PurpleHeart();
	private MedalOfHonor medalOfHonor = new MedalOfHonor();
	private boolean convertedImpreciseData = false;	
	
	public MsdsResponseInfo() {
		
	}

	/**
	 * @return the birlsMilitaryService
	 */
	public MilitaryService getBirlsMilitaryService() {
		return birlsMilitaryService;
	}

	/**
	 * @param birlsMilitaryService the birlsMilitaryService to set
	 */
	public void setBirlsMilitaryService(MilitaryService birlsMilitaryService) {
		this.birlsMilitaryService = birlsMilitaryService;
	}

	/**
	 * @return the birlsPerson
	 */
	public Person getBirlsPerson() {
		return birlsPerson;
	}

	/**
	 * @param birlsPerson the birlsPerson to set
	 */
	public void setBirlsPerson(Person birlsPerson) {
		this.birlsPerson = birlsPerson;
	}

	/**
	 * @return the hasMedalOfHonor
	 */
	public boolean isHasMedalOfHonor() {
		return (this.medalOfHonor != null && this.medalOfHonor.getMhIndicator() != null) ? 
				this.medalOfHonor.getMhIndicator().booleanValue() : false;
	}

	/**
	 * @param hasMedalOfHonor the hasMedalOfHonor to set
	 */
	public void setHasMedalOfHonor(Boolean hasMedalOfHonor) {
		if (this.medalOfHonor == null) {
			this.medalOfHonor = new MedalOfHonor();
		}
		this.medalOfHonor.setMhIndicator(hasMedalOfHonor);
	}

	/**
	 * @return the hasPurpleHeart
	 */
	public boolean isHasPurpleHeart() {
		return (this.purpleHeart != null && this.purpleHeart.getPhIndicator() != null) ? 
				this.purpleHeart.getPhIndicator().booleanValue() : false;
	}

	/**
	 * @param hasPurpleHeart the hasPurpleHeart to set
	 */
	public void setHasPurpleHeart(Boolean hasPurpleHeart) {
		if (this.purpleHeart == null) {
			this.purpleHeart = new PurpleHeart();
		}
		this.purpleHeart.setPhIndicator(hasPurpleHeart); 
	}

	/**
	 * @return the personEntityKey
	 */
	public PersonEntityKey getPersonEntityKey() {
		return personEntityKey;
	}

	/**
	 * @param personEntityKey the personEntityKey to set
	 */
	public void setPersonEntityKey(PersonEntityKey personEntityKey) {
		this.personEntityKey = personEntityKey;
	}

	/**
	 * @return the vadirMilitaryService
	 */
	public MilitaryService getVadirMilitaryService() {
		return vadirMilitaryService;
	}

	/**
	 * @param vadirMilitaryService the vadirMilitaryService to set
	 */
	public void setVadirMilitaryService(MilitaryService vadirMilitaryService) {
		this.vadirMilitaryService = vadirMilitaryService;
	}

	/**
	 * @return the vadirPerson
	 */
	public Person getVadirPerson() {
		return vadirPerson;
	}

	/**
	 * @param vadirPerson the vadirPerson to set
	 */
	public void setVadirPerson(Person vadirPerson) {
		this.vadirPerson = vadirPerson;
	}

	/**
	 * @return the msdsReceivedStatus
	 */
	public String getMsdsReceivedStatus() {
		return msdsReceivedStatus;
	}

	/**
	 * @param msdsReceivedStatus the msdsReceivedStatus to set
	 */
	public void setMsdsReceivedStatus(String msdsReceivedStatus) {
		this.msdsReceivedStatus = msdsReceivedStatus;
	}

	/**
	 * @return the esrPerson
	 */
	public Person getEsrPerson() {
		return esrPerson;
	}

	/**
	 * @param esrPerson the esrPerson to set
	 */
	public void setEsrPerson(Person esrPerson) {
		this.esrPerson = esrPerson;
	}

	/**
	 * @return the hasDisabilityRetirement
	 */
	public boolean isHasDisabilityRetirement() {
		return hasDisabilityRetirement;
	}

	/**
	 * @param hasDisabilityRetirement the hasDisabilityRetirement to set
	 */
	public void setHasDisabilityRetirement(boolean hasDisabilityRetirement) {
		this.hasDisabilityRetirement = hasDisabilityRetirement;
	}

	/**
	 * @return the oefoifInd
	 */
	public String getOefoifInd() {
		return oefoifInd;
	}

	/**
	 * @param oefoifInd the oefoifInd to set
	 */
	public void setOefoifInd(String oefoifInd) {
		this.oefoifInd = oefoifInd;
	}

	/**
	 * @return the medalOfHonor
	 */
	public MedalOfHonor getMedalOfHonor() {
		return medalOfHonor;
	}

	/**
	 * @param medalOfHonor the medalOfHonor to set
	 */
	public void setMedalOfHonor(MedalOfHonor medalOfHonor) {
		this.medalOfHonor = medalOfHonor;
	}

	/**
	 * @return the purpleHeart
	 */
	public PurpleHeart getPurpleHeart() {
		return purpleHeart;
	}

	/**
	 * @param purpleHeart the purpleHeart to set
	 */
	public void setPurpleHeart(PurpleHeart purpleHeart) {
		this.purpleHeart = purpleHeart;
	}

	/**
	 * @return the birlsError
	 */
	public String getBirlsError() {
		return birlsError;
	}

	/**
	 * @param birlsError the birlsError to set
	 */
	public void setBirlsError(String birlsError) {
		this.birlsError = birlsError;
	}

	/**
	 * @return the vadirError
	 */
	public String getVadirError() {
		return vadirError;
	}

	/**
	 * @param vadirError the vadirError to set
	 */
	public void setVadirError(String vadirError) {
		this.vadirError = vadirError;
	}

	/**
	 * @return the msdsWorkItem
	 */
	public String getMsdsWorkItem() {
		return msdsWorkItem;
	}

	/**
	 * @param msdsWorkItem the msdsWorkItem to set
	 */
	public void setMsdsWorkItem(String msdsWorkItem) {
		this.msdsWorkItem = msdsWorkItem;
	}
	
	public boolean isConvertedImpreciseData() {
		return convertedImpreciseData;
	}

	public void setConvertedImpreciseData(boolean convertedImpreciseData) {
		this.convertedImpreciseData = convertedImpreciseData;
	}

	/**
	 * @return the satisfiesUpgradeCriteria
	 */
	public boolean isSatisfiesUpgradeCriteria() {
		return satisfiesUpgradeCriteria;
	}

	/**
	 * @param satisfiesUpgradeCriteria the satisfiesUpgradeCriteria to set
	 */
	public void setSatisfiesUpgradeCriteria(boolean satisfiesUpgradeCriteria) {
		this.satisfiesUpgradeCriteria = satisfiesUpgradeCriteria;
	}

	public boolean isProcessQMSEflow() {
		return processQMSEflow;
	}

	public void setProcessQMSEflow(boolean processQMSEflow) {
		this.processQMSEflow = processQMSEflow;
	}

	public boolean isHasQmse() {
		return hasQmse;
	}

	public void setHasQmse(boolean hasQmse) {
		this.hasQmse = hasQmse;
	}
	
}
