/********************************************************************
 * Copyright  2004 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service;

// Java classes
import java.util.Set;

import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.service.ServiceException;

import gov.va.med.esr.common.batchprocess.LoadVSSCDataResult;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.MsdsResponseInfo;

/** Provides business methods to implement use cases regarding updating
 * military service information and historical data of military service
 * information
 *
 * Project: Common
 * @author DNS   LEV
 * @version 1.0
 */
public interface MilitaryInfoService extends HistoricalInfoService {

   /** Returns historical data from military service by specific site
    * @param key An entity key of a site
    * @return A collection of military service historical data
    * @throws ServiceException Thrown in case of errors
    */
   public Set getHistoricalMilitaryServiceBySite( EntityKey key ) throws ServiceException;
   /** Update military service information.  This method implements a use case of updating
    * military information from a GUI screen.
    * @param incoming An incoming person containing military information to update
    * @return Person An updated person
    * @throws ServiceException thrown in case of errors
    */
   public Person updateMilitaryServiceInformation( Person incoming ) throws ServiceException;

   /** Calculates a period of service.  This method is called from a military service
    * information screen to allow a user to calculate a period of service before
    * submitting military information data for an update.
    * @param incoming An incoming veteran from a GUI screen
    * @return Person an undated person
    * @throws ServiceException thrown in case of errors
    * Note: Method name is called update to trigger a transaction.
    */
   public Person updateCalculatePeriodOfService(Person incoming) throws ServiceException;

   /**
    * Updates Military service information with the data from VSSC
    * @param person
    * @return LoadVSSCDataResult
    * @throws ServiceException
    */
   public LoadVSSCDataResult processVSSCData(Person person) throws ServiceException;

   /**
    * CCR 8395
    * Process MSDS Data from Broker
    *
    * @param person
    * @throws ServiceException
    * @return person
    */
   public Person processMSDSData(Person person) throws ServiceException;

   /**
    * CCR 8395
    * Process the MSDS message results
    *
    * @param response
    * @return
    * @throws ServiceException
    */
   public Person processMSDSData(MsdsResponseInfo response) throws ServiceException;

   /**
    * Updates Military service information using seeding rules
    * @param person
    * @return updatedMSPerson
    * @throws ServiceException
    */
   public Person processSeeding(Person person) throws ServiceException;

   //////CLV////////////
   public boolean calculateCLVeligibilitybyMSE(Person person) throws ServiceException;
   public void processMSDSLogicForCLV(Person incoming) throws ServiceException;

   /**
    * Get Service Start Date for imprecise dates to make them precise
    * @param serviceEntryDate
    * @return serviceEntryDate
    * @throws ServiceException
    */
   public String getPreciseServiceEntryDate(String serviceEntryDate)throws ServiceException;
   /**
    * Get Service EndDate for imprecise dates to make them precise
    * @param serviceSeparationDate
    * @return serviceSeparationDate
    * @throws ServiceException
    */
   public String getPreciseServiceSeparationDate(String serviceSeparationDate)throws ServiceException;



}
