/********************************************************************
 * Copyright  2005 VHA. All rights reserved
 ********************************************************************/
package gov.va.med.esr.service;

//Java classes

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import gov.va.med.esr.common.model.lookup.MessageStatus;
import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.fw.service.pagination.SearchQueryInfo;

/**
 * Serach criteria for Message Log Entry.
 * 
 * @author Muddaiah Ranga
 * @version 3.0
 */
public class MessageLogCriteria extends SearchQueryInfo implements Serializable
{
    private static final long serialVersionUID = -8696024008272317439L;
    
    private BigDecimal personId;
    private Date transmissionDate;
    private Date transmissionStartDate; 
    private Date transmissionEndDate;
    private VAFacility facility;
    private MessageType type;
    private MessageStatus status;
    
    
    public BigDecimal getPersonId() {
        return personId;
    }

    public void setPersonId(BigDecimal personId) {
        this.personId = personId;
    }

    public Date getTransmissionDate() {
        return transmissionDate;
    }
    
    public void setTransmissionDate(Date transmissionDate) {
        this.transmissionDate = transmissionDate;
    }
    
    public Date getTransmissionStartDate() {
        return transmissionStartDate;
    }
    
    public void setTransmissionStartDate(Date transmissionStartDate) {
        this.transmissionStartDate = transmissionStartDate;
    }
    
    public Date getTransmissionEndDate() {
        return transmissionEndDate;
    }
    
    public void setTransmissionEndDate(Date transmissionEndDate) {
        this.transmissionEndDate = transmissionEndDate;
    }
    
    public VAFacility getFacility() {
        return facility;
    }
    
    public void setFacility(VAFacility facility) {
        this.facility = facility;
    }
    
    public MessageType getType() {
        return type;
    }
    
    public void setType(MessageType type) {
        this.type = type;
    }

    public MessageStatus getStatus() {
        return status;
    }
    
    public void setStatus(MessageStatus status) {
        this.status = status;
    }  
}