package gov.va.med.esr.service;

import gov.va.med.esr.common.model.messaging.MsdsErrorLogEntry;
import gov.va.med.esr.common.model.messaging.MsdsMessageLogEntry;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.service.ServiceException;

import java.io.Serializable;
import java.math.BigDecimal;

public interface LogTransmissionService extends Serializable {
	
	public String generateControlIdentifier() throws ServiceException;
	
	public MsdsMessageLogEntry logMessage(MsdsMessageLogEntry entry) throws ServiceException;
	
	public void logMessage(MsdsErrorLogEntry errorEntry) throws ServiceException;
	
	public MsdsMessageLogEntry getMessageLogEntryById( BigDecimal id)throws ServiceException;
	
	public MsdsMessageLogEntry getMessageLogEntry( BigDecimal id )throws ServiceException;
	
	public boolean findCountCompletion(EntityKey personId) throws ServiceException;
	
	public MsdsMessageLogEntry getClockEntry(EntityKey personId)throws ServiceException;
	
	public void logMessagePayload(MsdsMessageLogEntry entry, String request, String response) throws ServiceException;

}
