package gov.va.med.esr.service;

import java.io.Serializable;

import gov.va.med.esr.common.model.lookup.ReportExceptionType;
import gov.va.med.esr.common.model.registry.Registry;

/**
 * Class to return results from processing Registry.
 *  
 * @author DNS   ruizc
 * @version 3.0
 */
public class LoadRegistryResult implements Serializable {
    
    /**
     * 
     */
    private static final long serialVersionUID = 818466831261640658L;
    
    private Registry resultRegistry = null; 
    
    private boolean ambiguousMatch = false;

    private boolean exactMatch = false;
    
    private boolean exactMatchSameEpisode = false;
    
    private boolean exactMatchDifferentEpisode = false;    
    
    private boolean newRegistry = false;    
    
    private ReportExceptionType exceptionType = null;
    
    public LoadRegistryResult() {
        super();

    }

    /**
     * @return Returns the ambiguousMatch.
     */
    public boolean isAmbiguousMatch() {
        return ambiguousMatch;
    }

    /**
     * @param ambiguousMatch The ambiguousMatch to set.
     */
    public void setAmbiguousMatch(boolean ambiguousMatch) {
        this.ambiguousMatch = ambiguousMatch;
    }


    /**
     * @return Returns the exception.
     */
    public ReportExceptionType getExceptionType() {
        return exceptionType;
    }

    /**
     * @param exception The exception to set.
     */
    public void setExceptionType(ReportExceptionType exceptionType) {
        this.exceptionType = exceptionType;
    }

    /**
     * @return Returns the resultRegistry.
     */
    public Registry getResultRegistry() {
        return resultRegistry;
    }

    /**
     * @param resultRegistry The resultRegistry to set.
     */
    public void setResultRegistry(Registry resultRegistry) {
        this.resultRegistry = resultRegistry;
    }

    /**
     * @return Returns the newRegistry.
     */
    public boolean isNewRegistry() {
        return newRegistry;
    }

    /**
     * @param newRegistry The newRegistry to set.
     */
    public void setNewRegistry(boolean newRegistry) {
        this.newRegistry = newRegistry;
    }

    
    /**
     * @return Returns the exactMatch.
     */
    public boolean isExactMatch()
    {
        return exactMatch;
    }
    /**
     * @param exactMatch The exactMatch to set.
     */
    public void setExactMatch(boolean exactMatch)
    {
        this.exactMatch = exactMatch;
    }
    
    /**
     * @return Returns the exactMatchDifferentEpisode.
     */
    public boolean isExactMatchDifferentEpisode() {
        return exactMatchDifferentEpisode;
    }

    /**
     * @param exactMatchDifferentEpisode The exactMatchDifferentEpisode to set.
     */
    public void setExactMatchDifferentEpisode(boolean exactMatchDifferentEpisode) {
        this.exactMatchDifferentEpisode = exactMatchDifferentEpisode;
    }

    /**
     * @return Returns the exactMatchSameEpisode.
     */
    public boolean isExactMatchSameEpisode() {
        return exactMatchSameEpisode;
    }

    /**
     * @param exactMatchSameEpisode The exactMatchSameEpisode to set.
     */
    public void setExactMatchSameEpisode(boolean exactMatchSameEpisode) {
        this.exactMatchSameEpisode = exactMatchSameEpisode;
    }
    
}
